/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeFleetUtilizationRequestMarshaller
implements Marshaller<Request<DescribeFleetUtilizationRequest>, DescribeFleetUtilizationRequest> {
    public Request<DescribeFleetUtilizationRequest> marshall(DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        if (describeFleetUtilizationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFleetUtilizationRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetUtilization");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<String> fleetIdsList = describeFleetUtilizationRequest.getFleetIds();
            if (fleetIdsList != null) {
                jsonGenerator.writeFieldName("FleetIds");
                jsonGenerator.writeStartArray();
                for (String fleetIdsListValue : fleetIdsList) {
                    if (fleetIdsListValue == null) continue;
                    jsonGenerator.writeValue(fleetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeFleetUtilizationRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue((long)describeFleetUtilizationRequest.getLimit().intValue());
            }
            if (describeFleetUtilizationRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeFleetUtilizationRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

