/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ListBuildsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListBuildsRequestMarshaller
implements Marshaller<Request<ListBuildsRequest>, ListBuildsRequest> {
    public Request<ListBuildsRequest> marshall(ListBuildsRequest listBuildsRequest) {
        if (listBuildsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listBuildsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListBuilds");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listBuildsRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(listBuildsRequest.getStatus());
            }
            if (listBuildsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue((long)listBuildsRequest.getLimit().intValue());
            }
            if (listBuildsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listBuildsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

