/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeGameSessionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeGameSessionsRequestMarshaller
implements Marshaller<Request<DescribeGameSessionsRequest>, DescribeGameSessionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeGameSessionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeGameSessionsRequest> marshall(DescribeGameSessionsRequest describeGameSessionsRequest) {
        if (describeGameSessionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeGameSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeGameSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeGameSessionsRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(describeGameSessionsRequest.getFleetId());
            }
            if (describeGameSessionsRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(describeGameSessionsRequest.getGameSessionId());
            }
            if (describeGameSessionsRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(describeGameSessionsRequest.getAliasId());
            }
            if (describeGameSessionsRequest.getStatusFilter() != null) {
                jsonGenerator.writeFieldName("StatusFilter").writeValue(describeGameSessionsRequest.getStatusFilter());
            }
            if (describeGameSessionsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeGameSessionsRequest.getLimit().intValue());
            }
            if (describeGameSessionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeGameSessionsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

