/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.RuntimeConfiguration;
import com.amazonaws.services.gamelift.model.ServerProcess;
import com.amazonaws.services.gamelift.model.transform.ServerProcessJsonMarshaller;
import java.util.List;

public class RuntimeConfigurationJsonMarshaller {
    private static RuntimeConfigurationJsonMarshaller instance;

    public void marshall(RuntimeConfiguration runtimeConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (runtimeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<ServerProcess> serverProcessesList = runtimeConfiguration.getServerProcesses();
            if (serverProcessesList != null) {
                jsonGenerator.writeFieldName("ServerProcesses");
                jsonGenerator.writeStartArray();
                for (ServerProcess serverProcessesListValue : serverProcessesList) {
                    if (serverProcessesListValue == null) continue;
                    ServerProcessJsonMarshaller.getInstance().marshall(serverProcessesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RuntimeConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RuntimeConfigurationJsonMarshaller();
        }
        return instance;
    }
}

