/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamelift.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum GameServerGroupInstanceType {

    C4Large("c4.large"),
    C4Xlarge("c4.xlarge"),
    C42xlarge("c4.2xlarge"),
    C44xlarge("c4.4xlarge"),
    C48xlarge("c4.8xlarge"),
    C5Large("c5.large"),
    C5Xlarge("c5.xlarge"),
    C52xlarge("c5.2xlarge"),
    C54xlarge("c5.4xlarge"),
    C59xlarge("c5.9xlarge"),
    C512xlarge("c5.12xlarge"),
    C518xlarge("c5.18xlarge"),
    C524xlarge("c5.24xlarge"),
    C5aLarge("c5a.large"),
    C5aXlarge("c5a.xlarge"),
    C5a2xlarge("c5a.2xlarge"),
    C5a4xlarge("c5a.4xlarge"),
    C5a8xlarge("c5a.8xlarge"),
    C5a12xlarge("c5a.12xlarge"),
    C5a16xlarge("c5a.16xlarge"),
    C5a24xlarge("c5a.24xlarge"),
    C6gMedium("c6g.medium"),
    C6gLarge("c6g.large"),
    C6gXlarge("c6g.xlarge"),
    C6g2xlarge("c6g.2xlarge"),
    C6g4xlarge("c6g.4xlarge"),
    C6g8xlarge("c6g.8xlarge"),
    C6g12xlarge("c6g.12xlarge"),
    C6g16xlarge("c6g.16xlarge"),
    R4Large("r4.large"),
    R4Xlarge("r4.xlarge"),
    R42xlarge("r4.2xlarge"),
    R44xlarge("r4.4xlarge"),
    R48xlarge("r4.8xlarge"),
    R416xlarge("r4.16xlarge"),
    R5Large("r5.large"),
    R5Xlarge("r5.xlarge"),
    R52xlarge("r5.2xlarge"),
    R54xlarge("r5.4xlarge"),
    R58xlarge("r5.8xlarge"),
    R512xlarge("r5.12xlarge"),
    R516xlarge("r5.16xlarge"),
    R524xlarge("r5.24xlarge"),
    R5aLarge("r5a.large"),
    R5aXlarge("r5a.xlarge"),
    R5a2xlarge("r5a.2xlarge"),
    R5a4xlarge("r5a.4xlarge"),
    R5a8xlarge("r5a.8xlarge"),
    R5a12xlarge("r5a.12xlarge"),
    R5a16xlarge("r5a.16xlarge"),
    R5a24xlarge("r5a.24xlarge"),
    R6gMedium("r6g.medium"),
    R6gLarge("r6g.large"),
    R6gXlarge("r6g.xlarge"),
    R6g2xlarge("r6g.2xlarge"),
    R6g4xlarge("r6g.4xlarge"),
    R6g8xlarge("r6g.8xlarge"),
    R6g12xlarge("r6g.12xlarge"),
    R6g16xlarge("r6g.16xlarge"),
    M4Large("m4.large"),
    M4Xlarge("m4.xlarge"),
    M42xlarge("m4.2xlarge"),
    M44xlarge("m4.4xlarge"),
    M410xlarge("m4.10xlarge"),
    M5Large("m5.large"),
    M5Xlarge("m5.xlarge"),
    M52xlarge("m5.2xlarge"),
    M54xlarge("m5.4xlarge"),
    M58xlarge("m5.8xlarge"),
    M512xlarge("m5.12xlarge"),
    M516xlarge("m5.16xlarge"),
    M524xlarge("m5.24xlarge"),
    M5aLarge("m5a.large"),
    M5aXlarge("m5a.xlarge"),
    M5a2xlarge("m5a.2xlarge"),
    M5a4xlarge("m5a.4xlarge"),
    M5a8xlarge("m5a.8xlarge"),
    M5a12xlarge("m5a.12xlarge"),
    M5a16xlarge("m5a.16xlarge"),
    M5a24xlarge("m5a.24xlarge"),
    M6gMedium("m6g.medium"),
    M6gLarge("m6g.large"),
    M6gXlarge("m6g.xlarge"),
    M6g2xlarge("m6g.2xlarge"),
    M6g4xlarge("m6g.4xlarge"),
    M6g8xlarge("m6g.8xlarge"),
    M6g12xlarge("m6g.12xlarge"),
    M6g16xlarge("m6g.16xlarge");

    private String value;

    private GameServerGroupInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return GameServerGroupInstanceType corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static GameServerGroupInstanceType fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (GameServerGroupInstanceType enumEntry : GameServerGroupInstanceType.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
