/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>GameLift Service</fullname>
 * <p>
 * Amazon Web Services provides solutions for hosting session-based multiplayer game servers in the cloud, including
 * tools for deploying, operating, and scaling game servers. Built on Amazon Web Services global computing
 * infrastructure, GameLift helps you deliver high-performance, high-reliability, low-cost game servers while
 * dynamically scaling your resource usage to meet player demand.
 * </p>
 * <p>
 * <b>About GameLift solutions</b>
 * </p>
 * <p>
 * Get more information on these GameLift solutions in the <a
 * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/">GameLift Developer Guide</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * GameLift managed hosting -- GameLift offers a fully managed service to set up and maintain computing machines for
 * hosting, manage game session and player session life cycle, and handle security, storage, and performance tracking.
 * You can use automatic scaling tools to balance player demand and hosting costs, configure your game session
 * management to minimize player latency, and add FlexMatch for matchmaking.
 * </p>
 * </li>
 * <li>
 * <p>
 * Managed hosting with Realtime Servers -- With GameLift Realtime Servers, you can quickly configure and set up
 * ready-to-go game servers for your game. Realtime Servers provides a game server framework with core GameLift
 * infrastructure already built in. Then use the full range of GameLift managed hosting features, including FlexMatch,
 * for your game.
 * </p>
 * </li>
 * <li>
 * <p>
 * GameLift FleetIQ -- Use GameLift FleetIQ as a standalone service while hosting your games using EC2 instances and
 * Auto Scaling groups. GameLift FleetIQ provides optimizations for game hosting, including boosting the viability of
 * low-cost Spot Instances gaming. For a complete solution, pair the GameLift FleetIQ and FlexMatch standalone services.
 * </p>
 * </li>
 * <li>
 * <p>
 * GameLift FlexMatch -- Add matchmaking to your game hosting solution. FlexMatch is a customizable matchmaking service
 * for multiplayer games. Use FlexMatch as integrated with GameLift managed hosting or incorporate FlexMatch as a
 * standalone service into your own hosting solution.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>About this API Reference</b>
 * </p>
 * <p>
 * This reference guide describes the low-level service API for Amazon Web Services. With each topic in this guide, you
 * can find links to language-specific SDK guides and the Amazon Web Services CLI reference. Useful links:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html">GameLift API operations
 * listed by tasks</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-components.html"> GameLift tools and
 * resources</a>
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.gamelift;

