/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamelift;

import javax.annotation.Generated;

import com.amazonaws.services.gamelift.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonGameLift}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonGameLift implements AmazonGameLift {

    protected AbstractAmazonGameLift() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AcceptMatchResult acceptMatch(AcceptMatchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ClaimGameServerResult claimGameServer(ClaimGameServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAliasResult createAlias(CreateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBuildResult createBuild(CreateBuildRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFleetResult createFleet(CreateFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFleetLocationsResult createFleetLocations(CreateFleetLocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGameServerGroupResult createGameServerGroup(CreateGameServerGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGameSessionResult createGameSession(CreateGameSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGameSessionQueueResult createGameSessionQueue(CreateGameSessionQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMatchmakingConfigurationResult createMatchmakingConfiguration(CreateMatchmakingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMatchmakingRuleSetResult createMatchmakingRuleSet(CreateMatchmakingRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePlayerSessionResult createPlayerSession(CreatePlayerSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePlayerSessionsResult createPlayerSessions(CreatePlayerSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateScriptResult createScript(CreateScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVpcPeeringAuthorizationResult createVpcPeeringAuthorization(CreateVpcPeeringAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVpcPeeringConnectionResult createVpcPeeringConnection(CreateVpcPeeringConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAliasResult deleteAlias(DeleteAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBuildResult deleteBuild(DeleteBuildRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetResult deleteFleet(DeleteFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFleetLocationsResult deleteFleetLocations(DeleteFleetLocationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGameServerGroupResult deleteGameServerGroup(DeleteGameServerGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGameSessionQueueResult deleteGameSessionQueue(DeleteGameSessionQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMatchmakingConfigurationResult deleteMatchmakingConfiguration(DeleteMatchmakingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMatchmakingRuleSetResult deleteMatchmakingRuleSet(DeleteMatchmakingRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScalingPolicyResult deleteScalingPolicy(DeleteScalingPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScriptResult deleteScript(DeleteScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVpcPeeringAuthorizationResult deleteVpcPeeringAuthorization(DeleteVpcPeeringAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVpcPeeringConnectionResult deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterGameServerResult deregisterGameServer(DeregisterGameServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAliasResult describeAlias(DescribeAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBuildResult describeBuild(DescribeBuildRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEC2InstanceLimitsResult describeEC2InstanceLimits(DescribeEC2InstanceLimitsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetAttributesResult describeFleetAttributes(DescribeFleetAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetCapacityResult describeFleetCapacity(DescribeFleetCapacityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetEventsResult describeFleetEvents(DescribeFleetEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetLocationAttributesResult describeFleetLocationAttributes(DescribeFleetLocationAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetLocationCapacityResult describeFleetLocationCapacity(DescribeFleetLocationCapacityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetLocationUtilizationResult describeFleetLocationUtilization(DescribeFleetLocationUtilizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetPortSettingsResult describeFleetPortSettings(DescribeFleetPortSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFleetUtilizationResult describeFleetUtilization(DescribeFleetUtilizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameServerResult describeGameServer(DescribeGameServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameServerGroupResult describeGameServerGroup(DescribeGameServerGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameServerInstancesResult describeGameServerInstances(DescribeGameServerInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameSessionDetailsResult describeGameSessionDetails(DescribeGameSessionDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameSessionPlacementResult describeGameSessionPlacement(DescribeGameSessionPlacementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameSessionQueuesResult describeGameSessionQueues(DescribeGameSessionQueuesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGameSessionsResult describeGameSessions(DescribeGameSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstancesResult describeInstances(DescribeInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMatchmakingResult describeMatchmaking(DescribeMatchmakingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMatchmakingConfigurationsResult describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMatchmakingRuleSetsResult describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePlayerSessionsResult describePlayerSessions(DescribePlayerSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRuntimeConfigurationResult describeRuntimeConfiguration(DescribeRuntimeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeScalingPoliciesResult describeScalingPolicies(DescribeScalingPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeScriptResult describeScript(DescribeScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVpcPeeringAuthorizationsResult describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVpcPeeringConnectionsResult describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGameSessionLogUrlResult getGameSessionLogUrl(GetGameSessionLogUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInstanceAccessResult getInstanceAccess(GetInstanceAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAliasesResult listAliases(ListAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBuildsResult listBuilds(ListBuildsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFleetsResult listFleets(ListFleetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGameServerGroupsResult listGameServerGroups(ListGameServerGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGameServersResult listGameServers(ListGameServersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListScriptsResult listScripts(ListScriptsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutScalingPolicyResult putScalingPolicy(PutScalingPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterGameServerResult registerGameServer(RegisterGameServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RequestUploadCredentialsResult requestUploadCredentials(RequestUploadCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResolveAliasResult resolveAlias(ResolveAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResumeGameServerGroupResult resumeGameServerGroup(ResumeGameServerGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchGameSessionsResult searchGameSessions(SearchGameSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartFleetActionsResult startFleetActions(StartFleetActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartGameSessionPlacementResult startGameSessionPlacement(StartGameSessionPlacementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMatchBackfillResult startMatchBackfill(StartMatchBackfillRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMatchmakingResult startMatchmaking(StartMatchmakingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopFleetActionsResult stopFleetActions(StopFleetActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopGameSessionPlacementResult stopGameSessionPlacement(StopGameSessionPlacementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopMatchmakingResult stopMatchmaking(StopMatchmakingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SuspendGameServerGroupResult suspendGameServerGroup(SuspendGameServerGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAliasResult updateAlias(UpdateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBuildResult updateBuild(UpdateBuildRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFleetAttributesResult updateFleetAttributes(UpdateFleetAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFleetCapacityResult updateFleetCapacity(UpdateFleetCapacityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFleetPortSettingsResult updateFleetPortSettings(UpdateFleetPortSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGameServerResult updateGameServer(UpdateGameServerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGameServerGroupResult updateGameServerGroup(UpdateGameServerGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGameSessionResult updateGameSession(UpdateGameSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGameSessionQueueResult updateGameSessionQueue(UpdateGameSessionQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMatchmakingConfigurationResult updateMatchmakingConfiguration(UpdateMatchmakingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRuntimeConfigurationResult updateRuntimeConfiguration(UpdateRuntimeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateScriptResult updateScript(UpdateScriptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ValidateMatchmakingRuleSetResult validateMatchmakingRuleSet(ValidateMatchmakingRuleSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
