/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gamelift.model.LocationModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLocationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<LocationModel> locations;
    private String nextToken;

    public List<LocationModel> getLocations() {
        return this.locations;
    }

    public void setLocations(Collection<LocationModel> locations) {
        if (locations == null) {
            this.locations = null;
            return;
        }
        this.locations = new ArrayList<LocationModel>(locations);
    }

    public ListLocationsResult withLocations(LocationModel ... locations) {
        if (this.locations == null) {
            this.setLocations(new ArrayList<LocationModel>(locations.length));
        }
        for (LocationModel ele : locations) {
            this.locations.add(ele);
        }
        return this;
    }

    public ListLocationsResult withLocations(Collection<LocationModel> locations) {
        this.setLocations(locations);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLocationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocations() != null) {
            sb.append("Locations: ").append(this.getLocations()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocationsResult)) {
            return false;
        }
        ListLocationsResult other = (ListLocationsResult)obj;
        if (other.getLocations() == null ^ this.getLocations() == null) {
            return false;
        }
        if (other.getLocations() != null && !other.getLocations().equals(this.getLocations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocations() == null ? 0 : this.getLocations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLocationsResult clone() {
        try {
            return (ListLocationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

