/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamelift.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListGameServersRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * An identifier for the game server group to retrieve a list of game servers from. Use either the name or ARN
     * value.
     * </p>
     */
    private String gameServerGroupName;
    /**
     * <p>
     * Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code>
     * to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If
     * this parameter is left empty, game servers are returned in no particular order.
     * </p>
     */
    private String sortOrder;
    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     */
    private Integer limit;
    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * An identifier for the game server group to retrieve a list of game servers from. Use either the name or ARN
     * value.
     * </p>
     * 
     * @param gameServerGroupName
     *        An identifier for the game server group to retrieve a list of game servers from. Use either the name or
     *        ARN value.
     */

    public void setGameServerGroupName(String gameServerGroupName) {
        this.gameServerGroupName = gameServerGroupName;
    }

    /**
     * <p>
     * An identifier for the game server group to retrieve a list of game servers from. Use either the name or ARN
     * value.
     * </p>
     * 
     * @return An identifier for the game server group to retrieve a list of game servers from. Use either the name or
     *         ARN value.
     */

    public String getGameServerGroupName() {
        return this.gameServerGroupName;
    }

    /**
     * <p>
     * An identifier for the game server group to retrieve a list of game servers from. Use either the name or ARN
     * value.
     * </p>
     * 
     * @param gameServerGroupName
     *        An identifier for the game server group to retrieve a list of game servers from. Use either the name or
     *        ARN value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGameServersRequest withGameServerGroupName(String gameServerGroupName) {
        setGameServerGroupName(gameServerGroupName);
        return this;
    }

    /**
     * <p>
     * Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code>
     * to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If
     * this parameter is left empty, game servers are returned in no particular order.
     * </p>
     * 
     * @param sortOrder
     *        Indicates how to sort the returned data based on game server registration timestamp. Use
     *        <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve
     *        newest game servers first. If this parameter is left empty, game servers are returned in no particular
     *        order.
     * @see SortOrder
     */

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    /**
     * <p>
     * Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code>
     * to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If
     * this parameter is left empty, game servers are returned in no particular order.
     * </p>
     * 
     * @return Indicates how to sort the returned data based on game server registration timestamp. Use
     *         <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve
     *         newest game servers first. If this parameter is left empty, game servers are returned in no particular
     *         order.
     * @see SortOrder
     */

    public String getSortOrder() {
        return this.sortOrder;
    }

    /**
     * <p>
     * Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code>
     * to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If
     * this parameter is left empty, game servers are returned in no particular order.
     * </p>
     * 
     * @param sortOrder
     *        Indicates how to sort the returned data based on game server registration timestamp. Use
     *        <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve
     *        newest game servers first. If this parameter is left empty, game servers are returned in no particular
     *        order.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public ListGameServersRequest withSortOrder(String sortOrder) {
        setSortOrder(sortOrder);
        return this;
    }

    /**
     * <p>
     * Indicates how to sort the returned data based on game server registration timestamp. Use <code>ASCENDING</code>
     * to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve newest game servers first. If
     * this parameter is left empty, game servers are returned in no particular order.
     * </p>
     * 
     * @param sortOrder
     *        Indicates how to sort the returned data based on game server registration timestamp. Use
     *        <code>ASCENDING</code> to retrieve oldest game servers first, or use <code>DESCENDING</code> to retrieve
     *        newest game servers first. If this parameter is left empty, game servers are returned in no particular
     *        order.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public ListGameServersRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @param limit
     *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *        a set of sequential pages.
     */

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */

    public Integer getLimit() {
        return this.limit;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @param limit
     *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *        a set of sequential pages.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGameServersRequest withLimit(Integer limit) {
        setLimit(limit);
        return this;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @param nextToken
     *        A token that indicates the start of the next sequential page of results. Use the token that is returned
     *        with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *        value.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @param nextToken
     *        A token that indicates the start of the next sequential page of results. Use the token that is returned
     *        with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *        value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGameServersRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGameServerGroupName() != null)
            sb.append("GameServerGroupName: ").append(getGameServerGroupName()).append(",");
        if (getSortOrder() != null)
            sb.append("SortOrder: ").append(getSortOrder()).append(",");
        if (getLimit() != null)
            sb.append("Limit: ").append(getLimit()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListGameServersRequest == false)
            return false;
        ListGameServersRequest other = (ListGameServersRequest) obj;
        if (other.getGameServerGroupName() == null ^ this.getGameServerGroupName() == null)
            return false;
        if (other.getGameServerGroupName() != null && other.getGameServerGroupName().equals(this.getGameServerGroupName()) == false)
            return false;
        if (other.getSortOrder() == null ^ this.getSortOrder() == null)
            return false;
        if (other.getSortOrder() != null && other.getSortOrder().equals(this.getSortOrder()) == false)
            return false;
        if (other.getLimit() == null ^ this.getLimit() == null)
            return false;
        if (other.getLimit() != null && other.getLimit().equals(this.getLimit()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGameServerGroupName() == null) ? 0 : getGameServerGroupName().hashCode());
        hashCode = prime * hashCode + ((getSortOrder() == null) ? 0 : getSortOrder().hashCode());
        hashCode = prime * hashCode + ((getLimit() == null) ? 0 : getLimit().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListGameServersRequest clone() {
        return (ListGameServersRequest) super.clone();
    }

}
