/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListJobsRequestMarshaller
implements Marshaller<Request<ListJobsRequest>, ListJobsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListJobsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListJobsRequest> marshall(ListJobsRequest listJobsRequest) {
        if (listJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listJobsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs";
        uriResourcePath = uriResourcePath.replace("{accountId}", listJobsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listJobsRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", listJobsRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listJobsRequest.getVaultName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (listJobsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromString((String)listJobsRequest.getLimit()));
        }
        if (listJobsRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listJobsRequest.getMarker()));
        }
        if (listJobsRequest.getStatuscode() != null) {
            request.addParameter("statuscode", StringUtils.fromString((String)listJobsRequest.getStatuscode()));
        }
        if (listJobsRequest.getCompleted() != null) {
            request.addParameter("completed", StringUtils.fromString((String)listJobsRequest.getCompleted()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

