/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UploadArchiveRequestMarshaller
implements Marshaller<Request<UploadArchiveRequest>, UploadArchiveRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<UploadArchiveRequest> marshall(UploadArchiveRequest uploadArchiveRequest) {
        String value;
        String name;
        if (uploadArchiveRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadArchiveRequest, "AmazonGlacier");
        String target = "Glacier.UploadArchive";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadArchiveRequest.getContentLength() != null) {
            request.addHeader("x-amz-content-length", StringUtils.fromLong((Long)uploadArchiveRequest.getContentLength()));
        }
        if (uploadArchiveRequest.getArchiveDescription() != null) {
            request.addHeader("x-amz-archive-description", StringUtils.fromString((String)uploadArchiveRequest.getArchiveDescription()));
        }
        if (uploadArchiveRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString((String)uploadArchiveRequest.getChecksum()));
        }
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string = value = uploadArchiveRequest.getVaultName() == null ? null : StringUtils.fromString((String)uploadArchiveRequest.getVaultName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", uploadArchiveRequest.getVaultName() == null ? "" : StringUtils.fromString((String)uploadArchiveRequest.getVaultName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = uploadArchiveRequest.getAccountId() == null ? null : StringUtils.fromString((String)uploadArchiveRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", uploadArchiveRequest.getAccountId() == null ? "" : StringUtils.fromString((String)uploadArchiveRequest.getAccountId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(uploadArchiveRequest.getBody());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/archives";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

