/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDataQualityRuleRecommendationRuns"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListDataQualityRuleRecommendationRunsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * </p>
     */
    private java.util.List<DataQualityRuleRecommendationRunDescription> runs;
    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * </p>
     * 
     * @return A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     */

    public java.util.List<DataQualityRuleRecommendationRunDescription> getRuns() {
        return runs;
    }

    /**
     * <p>
     * A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * </p>
     * 
     * @param runs
     *        A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     */

    public void setRuns(java.util.Collection<DataQualityRuleRecommendationRunDescription> runs) {
        if (runs == null) {
            this.runs = null;
            return;
        }

        this.runs = new java.util.ArrayList<DataQualityRuleRecommendationRunDescription>(runs);
    }

    /**
     * <p>
     * A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRuns(java.util.Collection)} or {@link #withRuns(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param runs
     *        A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataQualityRuleRecommendationRunsResult withRuns(DataQualityRuleRecommendationRunDescription... runs) {
        if (this.runs == null) {
            setRuns(new java.util.ArrayList<DataQualityRuleRecommendationRunDescription>(runs.length));
        }
        for (DataQualityRuleRecommendationRunDescription ele : runs) {
            this.runs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * </p>
     * 
     * @param runs
     *        A list of <code>DataQualityRuleRecommendationRunDescription</code> objects.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataQualityRuleRecommendationRunsResult withRuns(java.util.Collection<DataQualityRuleRecommendationRunDescription> runs) {
        setRuns(runs);
        return this;
    }

    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     * 
     * @param nextToken
     *        A pagination token, if more results are available.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     * 
     * @return A pagination token, if more results are available.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     * 
     * @param nextToken
     *        A pagination token, if more results are available.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataQualityRuleRecommendationRunsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRuns() != null)
            sb.append("Runs: ").append(getRuns()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListDataQualityRuleRecommendationRunsResult == false)
            return false;
        ListDataQualityRuleRecommendationRunsResult other = (ListDataQualityRuleRecommendationRunsResult) obj;
        if (other.getRuns() == null ^ this.getRuns() == null)
            return false;
        if (other.getRuns() != null && other.getRuns().equals(this.getRuns()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRuns() == null) ? 0 : getRuns().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListDataQualityRuleRecommendationRunsResult clone() {
        try {
            return (ListDataQualityRuleRecommendationRunsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
