/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.glue.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * JDBCConnectorSource JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class JDBCConnectorSourceJsonUnmarshaller implements Unmarshaller<JDBCConnectorSource, JsonUnmarshallerContext> {

    public JDBCConnectorSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        JDBCConnectorSource jDBCConnectorSource = new JDBCConnectorSource();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ConnectionName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setConnectionName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ConnectorName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setConnectorName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ConnectionType", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setConnectionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AdditionalOptions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setAdditionalOptions(JDBCConnectorOptionsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ConnectionTable", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setConnectionTable(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Query", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setQuery(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OutputSchemas", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    jDBCConnectorSource.setOutputSchemas(new ListUnmarshaller<GlueSchema>(GlueSchemaJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return jDBCConnectorSource;
    }

    private static JDBCConnectorSourceJsonUnmarshaller instance;

    public static JDBCConnectorSourceJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new JDBCConnectorSourceJsonUnmarshaller();
        return instance;
    }
}
