/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.glue.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * WorkflowRunStatistics JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class WorkflowRunStatisticsJsonUnmarshaller implements Unmarshaller<WorkflowRunStatistics, JsonUnmarshallerContext> {

    public WorkflowRunStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        WorkflowRunStatistics workflowRunStatistics = new WorkflowRunStatistics();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("TotalActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setTotalActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("TimeoutActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setTimeoutActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("FailedActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setFailedActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("StoppedActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setStoppedActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("SucceededActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setSucceededActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("RunningActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setRunningActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ErroredActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setErroredActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("WaitingActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    workflowRunStatistics.setWaitingActions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return workflowRunStatistics;
    }

    private static WorkflowRunStatisticsJsonUnmarshaller instance;

    public static WorkflowRunStatisticsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new WorkflowRunStatisticsJsonUnmarshaller();
        return instance;
    }
}
