/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCustomEntityType" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetCustomEntityTypeResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the custom pattern that you retrieved.
     * </p>
     */
    private String name;
    /**
     * <p>
     * A regular expression string that is used for detecting sensitive data in a custom pattern.
     * </p>
     */
    private String regexString;
    /**
     * <p>
     * A list of context words if specified when you created the custom pattern. If none of these context words are
     * found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * </p>
     */
    private java.util.List<String> contextWords;

    /**
     * <p>
     * The name of the custom pattern that you retrieved.
     * </p>
     * 
     * @param name
     *        The name of the custom pattern that you retrieved.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the custom pattern that you retrieved.
     * </p>
     * 
     * @return The name of the custom pattern that you retrieved.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the custom pattern that you retrieved.
     * </p>
     * 
     * @param name
     *        The name of the custom pattern that you retrieved.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCustomEntityTypeResult withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * A regular expression string that is used for detecting sensitive data in a custom pattern.
     * </p>
     * 
     * @param regexString
     *        A regular expression string that is used for detecting sensitive data in a custom pattern.
     */

    public void setRegexString(String regexString) {
        this.regexString = regexString;
    }

    /**
     * <p>
     * A regular expression string that is used for detecting sensitive data in a custom pattern.
     * </p>
     * 
     * @return A regular expression string that is used for detecting sensitive data in a custom pattern.
     */

    public String getRegexString() {
        return this.regexString;
    }

    /**
     * <p>
     * A regular expression string that is used for detecting sensitive data in a custom pattern.
     * </p>
     * 
     * @param regexString
     *        A regular expression string that is used for detecting sensitive data in a custom pattern.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCustomEntityTypeResult withRegexString(String regexString) {
        setRegexString(regexString);
        return this;
    }

    /**
     * <p>
     * A list of context words if specified when you created the custom pattern. If none of these context words are
     * found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * </p>
     * 
     * @return A list of context words if specified when you created the custom pattern. If none of these context words
     *         are found within the vicinity of the regular expression the data will not be detected as sensitive data.
     */

    public java.util.List<String> getContextWords() {
        return contextWords;
    }

    /**
     * <p>
     * A list of context words if specified when you created the custom pattern. If none of these context words are
     * found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * </p>
     * 
     * @param contextWords
     *        A list of context words if specified when you created the custom pattern. If none of these context words
     *        are found within the vicinity of the regular expression the data will not be detected as sensitive data.
     */

    public void setContextWords(java.util.Collection<String> contextWords) {
        if (contextWords == null) {
            this.contextWords = null;
            return;
        }

        this.contextWords = new java.util.ArrayList<String>(contextWords);
    }

    /**
     * <p>
     * A list of context words if specified when you created the custom pattern. If none of these context words are
     * found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setContextWords(java.util.Collection)} or {@link #withContextWords(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param contextWords
     *        A list of context words if specified when you created the custom pattern. If none of these context words
     *        are found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCustomEntityTypeResult withContextWords(String... contextWords) {
        if (this.contextWords == null) {
            setContextWords(new java.util.ArrayList<String>(contextWords.length));
        }
        for (String ele : contextWords) {
            this.contextWords.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of context words if specified when you created the custom pattern. If none of these context words are
     * found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * </p>
     * 
     * @param contextWords
     *        A list of context words if specified when you created the custom pattern. If none of these context words
     *        are found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCustomEntityTypeResult withContextWords(java.util.Collection<String> contextWords) {
        setContextWords(contextWords);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getRegexString() != null)
            sb.append("RegexString: ").append(getRegexString()).append(",");
        if (getContextWords() != null)
            sb.append("ContextWords: ").append(getContextWords());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetCustomEntityTypeResult == false)
            return false;
        GetCustomEntityTypeResult other = (GetCustomEntityTypeResult) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getRegexString() == null ^ this.getRegexString() == null)
            return false;
        if (other.getRegexString() != null && other.getRegexString().equals(this.getRegexString()) == false)
            return false;
        if (other.getContextWords() == null ^ this.getContextWords() == null)
            return false;
        if (other.getContextWords() != null && other.getContextWords().equals(this.getContextWords()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getRegexString() == null) ? 0 : getRegexString().hashCode());
        hashCode = prime * hashCode + ((getContextWords() == null) ? 0 : getContextWords().hashCode());
        return hashCode;
    }

    @Override
    public GetCustomEntityTypeResult clone() {
        try {
            return (GetCustomEntityTypeResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
