/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredTableMetadata" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetUnfilteredTableMetadataResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A Table object containing the table metadata.
     * </p>
     */
    private Table table;
    /**
     * <p>
     * A list of column names that the user has been granted access to.
     * </p>
     */
    private java.util.List<String> authorizedColumns;
    /**
     * <p>
     * A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * </p>
     */
    private Boolean isRegisteredWithLakeFormation;
    /**
     * <p>
     * A list of column row filters.
     * </p>
     */
    private java.util.List<ColumnRowFilter> cellFilters;
    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     */
    private String queryAuthorizationId;
    /**
     * <p>
     * The resource ARN of the parent resource extracted from the request.
     * </p>
     */
    private String resourceArn;
    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     */
    private java.util.List<String> permissions;

    /**
     * <p>
     * A Table object containing the table metadata.
     * </p>
     * 
     * @param table
     *        A Table object containing the table metadata.
     */

    public void setTable(Table table) {
        this.table = table;
    }

    /**
     * <p>
     * A Table object containing the table metadata.
     * </p>
     * 
     * @return A Table object containing the table metadata.
     */

    public Table getTable() {
        return this.table;
    }

    /**
     * <p>
     * A Table object containing the table metadata.
     * </p>
     * 
     * @param table
     *        A Table object containing the table metadata.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withTable(Table table) {
        setTable(table);
        return this;
    }

    /**
     * <p>
     * A list of column names that the user has been granted access to.
     * </p>
     * 
     * @return A list of column names that the user has been granted access to.
     */

    public java.util.List<String> getAuthorizedColumns() {
        return authorizedColumns;
    }

    /**
     * <p>
     * A list of column names that the user has been granted access to.
     * </p>
     * 
     * @param authorizedColumns
     *        A list of column names that the user has been granted access to.
     */

    public void setAuthorizedColumns(java.util.Collection<String> authorizedColumns) {
        if (authorizedColumns == null) {
            this.authorizedColumns = null;
            return;
        }

        this.authorizedColumns = new java.util.ArrayList<String>(authorizedColumns);
    }

    /**
     * <p>
     * A list of column names that the user has been granted access to.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAuthorizedColumns(java.util.Collection)} or {@link #withAuthorizedColumns(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param authorizedColumns
     *        A list of column names that the user has been granted access to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withAuthorizedColumns(String... authorizedColumns) {
        if (this.authorizedColumns == null) {
            setAuthorizedColumns(new java.util.ArrayList<String>(authorizedColumns.length));
        }
        for (String ele : authorizedColumns) {
            this.authorizedColumns.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of column names that the user has been granted access to.
     * </p>
     * 
     * @param authorizedColumns
     *        A list of column names that the user has been granted access to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withAuthorizedColumns(java.util.Collection<String> authorizedColumns) {
        setAuthorizedColumns(authorizedColumns);
        return this;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * </p>
     * 
     * @param isRegisteredWithLakeFormation
     *        A Boolean value that indicates whether the partition location is registered with Lake Formation.
     */

    public void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
        this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * </p>
     * 
     * @return A Boolean value that indicates whether the partition location is registered with Lake Formation.
     */

    public Boolean getIsRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * </p>
     * 
     * @param isRegisteredWithLakeFormation
     *        A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
        setIsRegisteredWithLakeFormation(isRegisteredWithLakeFormation);
        return this;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * </p>
     * 
     * @return A Boolean value that indicates whether the partition location is registered with Lake Formation.
     */

    public Boolean isRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    /**
     * <p>
     * A list of column row filters.
     * </p>
     * 
     * @return A list of column row filters.
     */

    public java.util.List<ColumnRowFilter> getCellFilters() {
        return cellFilters;
    }

    /**
     * <p>
     * A list of column row filters.
     * </p>
     * 
     * @param cellFilters
     *        A list of column row filters.
     */

    public void setCellFilters(java.util.Collection<ColumnRowFilter> cellFilters) {
        if (cellFilters == null) {
            this.cellFilters = null;
            return;
        }

        this.cellFilters = new java.util.ArrayList<ColumnRowFilter>(cellFilters);
    }

    /**
     * <p>
     * A list of column row filters.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCellFilters(java.util.Collection)} or {@link #withCellFilters(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param cellFilters
     *        A list of column row filters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withCellFilters(ColumnRowFilter... cellFilters) {
        if (this.cellFilters == null) {
            setCellFilters(new java.util.ArrayList<ColumnRowFilter>(cellFilters.length));
        }
        for (ColumnRowFilter ele : cellFilters) {
            this.cellFilters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of column row filters.
     * </p>
     * 
     * @param cellFilters
     *        A list of column row filters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withCellFilters(java.util.Collection<ColumnRowFilter> cellFilters) {
        setCellFilters(cellFilters);
        return this;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @param queryAuthorizationId
     *        A cryptographically generated query identifier generated by Glue or Lake Formation.
     */

    public void setQueryAuthorizationId(String queryAuthorizationId) {
        this.queryAuthorizationId = queryAuthorizationId;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @return A cryptographically generated query identifier generated by Glue or Lake Formation.
     */

    public String getQueryAuthorizationId() {
        return this.queryAuthorizationId;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @param queryAuthorizationId
     *        A cryptographically generated query identifier generated by Glue or Lake Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withQueryAuthorizationId(String queryAuthorizationId) {
        setQueryAuthorizationId(queryAuthorizationId);
        return this;
    }

    /**
     * <p>
     * The resource ARN of the parent resource extracted from the request.
     * </p>
     * 
     * @param resourceArn
     *        The resource ARN of the parent resource extracted from the request.
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * The resource ARN of the parent resource extracted from the request.
     * </p>
     * 
     * @return The resource ARN of the parent resource extracted from the request.
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * The resource ARN of the parent resource extracted from the request.
     * </p>
     * 
     * @param resourceArn
     *        The resource ARN of the parent resource extracted from the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetUnfilteredTableMetadataResult withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * 
     * @return The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *         context is found.
     * @see Permission
     */

    public java.util.List<String> getPermissions() {
        return permissions;
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * 
     * @param permissions
     *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *        context is found.
     * @see Permission
     */

    public void setPermissions(java.util.Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }

        this.permissions = new java.util.ArrayList<String>(permissions);
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPermissions(java.util.Collection)} or {@link #withPermissions(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param permissions
     *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *        context is found.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Permission
     */

    public GetUnfilteredTableMetadataResult withPermissions(String... permissions) {
        if (this.permissions == null) {
            setPermissions(new java.util.ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * 
     * @param permissions
     *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *        context is found.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Permission
     */

    public GetUnfilteredTableMetadataResult withPermissions(java.util.Collection<String> permissions) {
        setPermissions(permissions);
        return this;
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * 
     * @param permissions
     *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *        context is found.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Permission
     */

    public GetUnfilteredTableMetadataResult withPermissions(Permission... permissions) {
        java.util.ArrayList<String> permissionsCopy = new java.util.ArrayList<String>(permissions.length);
        for (Permission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (getPermissions() == null) {
            setPermissions(permissionsCopy);
        } else {
            getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTable() != null)
            sb.append("Table: ").append(getTable()).append(",");
        if (getAuthorizedColumns() != null)
            sb.append("AuthorizedColumns: ").append(getAuthorizedColumns()).append(",");
        if (getIsRegisteredWithLakeFormation() != null)
            sb.append("IsRegisteredWithLakeFormation: ").append(getIsRegisteredWithLakeFormation()).append(",");
        if (getCellFilters() != null)
            sb.append("CellFilters: ").append(getCellFilters()).append(",");
        if (getQueryAuthorizationId() != null)
            sb.append("QueryAuthorizationId: ").append(getQueryAuthorizationId()).append(",");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn()).append(",");
        if (getPermissions() != null)
            sb.append("Permissions: ").append(getPermissions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetUnfilteredTableMetadataResult == false)
            return false;
        GetUnfilteredTableMetadataResult other = (GetUnfilteredTableMetadataResult) obj;
        if (other.getTable() == null ^ this.getTable() == null)
            return false;
        if (other.getTable() != null && other.getTable().equals(this.getTable()) == false)
            return false;
        if (other.getAuthorizedColumns() == null ^ this.getAuthorizedColumns() == null)
            return false;
        if (other.getAuthorizedColumns() != null && other.getAuthorizedColumns().equals(this.getAuthorizedColumns()) == false)
            return false;
        if (other.getIsRegisteredWithLakeFormation() == null ^ this.getIsRegisteredWithLakeFormation() == null)
            return false;
        if (other.getIsRegisteredWithLakeFormation() != null
                && other.getIsRegisteredWithLakeFormation().equals(this.getIsRegisteredWithLakeFormation()) == false)
            return false;
        if (other.getCellFilters() == null ^ this.getCellFilters() == null)
            return false;
        if (other.getCellFilters() != null && other.getCellFilters().equals(this.getCellFilters()) == false)
            return false;
        if (other.getQueryAuthorizationId() == null ^ this.getQueryAuthorizationId() == null)
            return false;
        if (other.getQueryAuthorizationId() != null && other.getQueryAuthorizationId().equals(this.getQueryAuthorizationId()) == false)
            return false;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        if (other.getPermissions() == null ^ this.getPermissions() == null)
            return false;
        if (other.getPermissions() != null && other.getPermissions().equals(this.getPermissions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTable() == null) ? 0 : getTable().hashCode());
        hashCode = prime * hashCode + ((getAuthorizedColumns() == null) ? 0 : getAuthorizedColumns().hashCode());
        hashCode = prime * hashCode + ((getIsRegisteredWithLakeFormation() == null) ? 0 : getIsRegisteredWithLakeFormation().hashCode());
        hashCode = prime * hashCode + ((getCellFilters() == null) ? 0 : getCellFilters().hashCode());
        hashCode = prime * hashCode + ((getQueryAuthorizationId() == null) ? 0 : getQueryAuthorizationId().hashCode());
        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        hashCode = prime * hashCode + ((getPermissions() == null) ? 0 : getPermissions().hashCode());
        return hashCode;
    }

    @Override
    public GetUnfilteredTableMetadataResult clone() {
        try {
            return (GetUnfilteredTableMetadataResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
