/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchGetPartitionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services
     * account ID is used by default.
     * </p>
     */
    private String catalogId;
    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     */
    private String databaseName;
    /**
     * <p>
     * The name of the partitions' table.
     * </p>
     */
    private String tableName;
    /**
     * <p>
     * A list of partition values identifying the partitions to retrieve.
     * </p>
     */
    private java.util.List<PartitionValueList> partitionsToGet;

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services
     * account ID is used by default.
     * </p>
     * 
     * @param catalogId
     *        The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web
     *        Services account ID is used by default.
     */

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services
     * account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web
     *         Services account ID is used by default.
     */

    public String getCatalogId() {
        return this.catalogId;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web Services
     * account ID is used by default.
     * </p>
     * 
     * @param catalogId
     *        The ID of the Data Catalog where the partitions in question reside. If none is supplied, the Amazon Web
     *        Services account ID is used by default.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetPartitionRequest withCatalogId(String catalogId) {
        setCatalogId(catalogId);
        return this;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @param databaseName
     *        The name of the catalog database where the partitions reside.
     */

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @return The name of the catalog database where the partitions reside.
     */

    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * <p>
     * The name of the catalog database where the partitions reside.
     * </p>
     * 
     * @param databaseName
     *        The name of the catalog database where the partitions reside.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetPartitionRequest withDatabaseName(String databaseName) {
        setDatabaseName(databaseName);
        return this;
    }

    /**
     * <p>
     * The name of the partitions' table.
     * </p>
     * 
     * @param tableName
     *        The name of the partitions' table.
     */

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * <p>
     * The name of the partitions' table.
     * </p>
     * 
     * @return The name of the partitions' table.
     */

    public String getTableName() {
        return this.tableName;
    }

    /**
     * <p>
     * The name of the partitions' table.
     * </p>
     * 
     * @param tableName
     *        The name of the partitions' table.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetPartitionRequest withTableName(String tableName) {
        setTableName(tableName);
        return this;
    }

    /**
     * <p>
     * A list of partition values identifying the partitions to retrieve.
     * </p>
     * 
     * @return A list of partition values identifying the partitions to retrieve.
     */

    public java.util.List<PartitionValueList> getPartitionsToGet() {
        return partitionsToGet;
    }

    /**
     * <p>
     * A list of partition values identifying the partitions to retrieve.
     * </p>
     * 
     * @param partitionsToGet
     *        A list of partition values identifying the partitions to retrieve.
     */

    public void setPartitionsToGet(java.util.Collection<PartitionValueList> partitionsToGet) {
        if (partitionsToGet == null) {
            this.partitionsToGet = null;
            return;
        }

        this.partitionsToGet = new java.util.ArrayList<PartitionValueList>(partitionsToGet);
    }

    /**
     * <p>
     * A list of partition values identifying the partitions to retrieve.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPartitionsToGet(java.util.Collection)} or {@link #withPartitionsToGet(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param partitionsToGet
     *        A list of partition values identifying the partitions to retrieve.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetPartitionRequest withPartitionsToGet(PartitionValueList... partitionsToGet) {
        if (this.partitionsToGet == null) {
            setPartitionsToGet(new java.util.ArrayList<PartitionValueList>(partitionsToGet.length));
        }
        for (PartitionValueList ele : partitionsToGet) {
            this.partitionsToGet.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of partition values identifying the partitions to retrieve.
     * </p>
     * 
     * @param partitionsToGet
     *        A list of partition values identifying the partitions to retrieve.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchGetPartitionRequest withPartitionsToGet(java.util.Collection<PartitionValueList> partitionsToGet) {
        setPartitionsToGet(partitionsToGet);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCatalogId() != null)
            sb.append("CatalogId: ").append(getCatalogId()).append(",");
        if (getDatabaseName() != null)
            sb.append("DatabaseName: ").append(getDatabaseName()).append(",");
        if (getTableName() != null)
            sb.append("TableName: ").append(getTableName()).append(",");
        if (getPartitionsToGet() != null)
            sb.append("PartitionsToGet: ").append(getPartitionsToGet());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchGetPartitionRequest == false)
            return false;
        BatchGetPartitionRequest other = (BatchGetPartitionRequest) obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null)
            return false;
        if (other.getCatalogId() != null && other.getCatalogId().equals(this.getCatalogId()) == false)
            return false;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null)
            return false;
        if (other.getDatabaseName() != null && other.getDatabaseName().equals(this.getDatabaseName()) == false)
            return false;
        if (other.getTableName() == null ^ this.getTableName() == null)
            return false;
        if (other.getTableName() != null && other.getTableName().equals(this.getTableName()) == false)
            return false;
        if (other.getPartitionsToGet() == null ^ this.getPartitionsToGet() == null)
            return false;
        if (other.getPartitionsToGet() != null && other.getPartitionsToGet().equals(this.getPartitionsToGet()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCatalogId() == null) ? 0 : getCatalogId().hashCode());
        hashCode = prime * hashCode + ((getDatabaseName() == null) ? 0 : getDatabaseName().hashCode());
        hashCode = prime * hashCode + ((getTableName() == null) ? 0 : getTableName().hashCode());
        hashCode = prime * hashCode + ((getPartitionsToGet() == null) ? 0 : getPartitionsToGet().hashCode());
        return hashCode;
    }

    @Override
    public BatchGetPartitionRequest clone() {
        return (BatchGetPartitionRequest) super.clone();
    }

}
