/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawls" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListCrawlsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * </p>
     */
    private java.util.List<CrawlerHistory> crawls;
    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * </p>
     * 
     * @return A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     */

    public java.util.List<CrawlerHistory> getCrawls() {
        return crawls;
    }

    /**
     * <p>
     * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * </p>
     * 
     * @param crawls
     *        A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     */

    public void setCrawls(java.util.Collection<CrawlerHistory> crawls) {
        if (crawls == null) {
            this.crawls = null;
            return;
        }

        this.crawls = new java.util.ArrayList<CrawlerHistory>(crawls);
    }

    /**
     * <p>
     * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCrawls(java.util.Collection)} or {@link #withCrawls(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param crawls
     *        A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCrawlsResult withCrawls(CrawlerHistory... crawls) {
        if (this.crawls == null) {
            setCrawls(new java.util.ArrayList<CrawlerHistory>(crawls.length));
        }
        for (CrawlerHistory ele : crawls) {
            this.crawls.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * </p>
     * 
     * @param crawls
     *        A list of <code>CrawlerHistory</code> objects representing the crawl runs that meet your criteria.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCrawlsResult withCrawls(java.util.Collection<CrawlerHistory> crawls) {
        setCrawls(crawls);
        return this;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @param nextToken
     *        A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *        list is not the last.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @param nextToken
     *        A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *        list is not the last.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCrawlsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCrawls() != null)
            sb.append("Crawls: ").append(getCrawls()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListCrawlsResult == false)
            return false;
        ListCrawlsResult other = (ListCrawlsResult) obj;
        if (other.getCrawls() == null ^ this.getCrawls() == null)
            return false;
        if (other.getCrawls() != null && other.getCrawls().equals(this.getCrawls()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCrawls() == null) ? 0 : getCrawls().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListCrawlsResult clone() {
        try {
            return (ListCrawlsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
