/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.glue.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ViewDefinitionInputMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ViewDefinitionInputMarshaller {

    private static final MarshallingInfo<Boolean> ISPROTECTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsProtected").build();
    private static final MarshallingInfo<String> DEFINER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Definer").build();
    private static final MarshallingInfo<List> REPRESENTATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Representations").build();
    private static final MarshallingInfo<List> SUBOBJECTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SubObjects").build();

    private static final ViewDefinitionInputMarshaller instance = new ViewDefinitionInputMarshaller();

    public static ViewDefinitionInputMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ViewDefinitionInput viewDefinitionInput, ProtocolMarshaller protocolMarshaller) {

        if (viewDefinitionInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(viewDefinitionInput.getIsProtected(), ISPROTECTED_BINDING);
            protocolMarshaller.marshall(viewDefinitionInput.getDefiner(), DEFINER_BINDING);
            protocolMarshaller.marshall(viewDefinitionInput.getRepresentations(), REPRESENTATIONS_BINDING);
            protocolMarshaller.marshall(viewDefinitionInput.getSubObjects(), SUBOBJECTS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
