/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Represents options that specify how and where in the Glue Data Catalog DataBrew writes the output generated by recipe
 * jobs.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DataCatalogOutput" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DataCatalogOutput implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     * </p>
     */
    private String catalogId;
    /**
     * <p>
     * The name of a database in the Data Catalog.
     * </p>
     */
    private String databaseName;
    /**
     * <p>
     * The name of a table in the Data Catalog.
     * </p>
     */
    private String tableName;
    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
     * </p>
     */
    private S3TableOutputOptions s3Options;
    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     */
    private DatabaseTableOutputOptions databaseOptions;
    /**
     * <p>
     * A value that, if true, means that any data in the location specified for output is overwritten with new output.
     * Not supported with DatabaseOptions.
     * </p>
     */
    private Boolean overwrite;

    /**
     * <p>
     * The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     * </p>
     * 
     * @param catalogId
     *        The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     */

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     * </p>
     * 
     * @return The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the
     *         data.
     */

    public String getCatalogId() {
        return this.catalogId;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     * </p>
     * 
     * @param catalogId
     *        The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataCatalogOutput withCatalogId(String catalogId) {
        setCatalogId(catalogId);
        return this;
    }

    /**
     * <p>
     * The name of a database in the Data Catalog.
     * </p>
     * 
     * @param databaseName
     *        The name of a database in the Data Catalog.
     */

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    /**
     * <p>
     * The name of a database in the Data Catalog.
     * </p>
     * 
     * @return The name of a database in the Data Catalog.
     */

    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * <p>
     * The name of a database in the Data Catalog.
     * </p>
     * 
     * @param databaseName
     *        The name of a database in the Data Catalog.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataCatalogOutput withDatabaseName(String databaseName) {
        setDatabaseName(databaseName);
        return this;
    }

    /**
     * <p>
     * The name of a table in the Data Catalog.
     * </p>
     * 
     * @param tableName
     *        The name of a table in the Data Catalog.
     */

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * <p>
     * The name of a table in the Data Catalog.
     * </p>
     * 
     * @return The name of a table in the Data Catalog.
     */

    public String getTableName() {
        return this.tableName;
    }

    /**
     * <p>
     * The name of a table in the Data Catalog.
     * </p>
     * 
     * @param tableName
     *        The name of a table in the Data Catalog.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataCatalogOutput withTableName(String tableName) {
        setTableName(tableName);
        return this;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
     * </p>
     * 
     * @param s3Options
     *        Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe
     *        jobs.
     */

    public void setS3Options(S3TableOutputOptions s3Options) {
        this.s3Options = s3Options;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
     * </p>
     * 
     * @return Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe
     *         jobs.
     */

    public S3TableOutputOptions getS3Options() {
        return this.s3Options;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
     * </p>
     * 
     * @param s3Options
     *        Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe
     *        jobs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataCatalogOutput withS3Options(S3TableOutputOptions s3Options) {
        setS3Options(s3Options);
        return this;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @param databaseOptions
     *        Represents options that specify how and where DataBrew writes the database output generated by recipe
     *        jobs.
     */

    public void setDatabaseOptions(DatabaseTableOutputOptions databaseOptions) {
        this.databaseOptions = databaseOptions;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @return Represents options that specify how and where DataBrew writes the database output generated by recipe
     *         jobs.
     */

    public DatabaseTableOutputOptions getDatabaseOptions() {
        return this.databaseOptions;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @param databaseOptions
     *        Represents options that specify how and where DataBrew writes the database output generated by recipe
     *        jobs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataCatalogOutput withDatabaseOptions(DatabaseTableOutputOptions databaseOptions) {
        setDatabaseOptions(databaseOptions);
        return this;
    }

    /**
     * <p>
     * A value that, if true, means that any data in the location specified for output is overwritten with new output.
     * Not supported with DatabaseOptions.
     * </p>
     * 
     * @param overwrite
     *        A value that, if true, means that any data in the location specified for output is overwritten with new
     *        output. Not supported with DatabaseOptions.
     */

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    /**
     * <p>
     * A value that, if true, means that any data in the location specified for output is overwritten with new output.
     * Not supported with DatabaseOptions.
     * </p>
     * 
     * @return A value that, if true, means that any data in the location specified for output is overwritten with new
     *         output. Not supported with DatabaseOptions.
     */

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    /**
     * <p>
     * A value that, if true, means that any data in the location specified for output is overwritten with new output.
     * Not supported with DatabaseOptions.
     * </p>
     * 
     * @param overwrite
     *        A value that, if true, means that any data in the location specified for output is overwritten with new
     *        output. Not supported with DatabaseOptions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DataCatalogOutput withOverwrite(Boolean overwrite) {
        setOverwrite(overwrite);
        return this;
    }

    /**
     * <p>
     * A value that, if true, means that any data in the location specified for output is overwritten with new output.
     * Not supported with DatabaseOptions.
     * </p>
     * 
     * @return A value that, if true, means that any data in the location specified for output is overwritten with new
     *         output. Not supported with DatabaseOptions.
     */

    public Boolean isOverwrite() {
        return this.overwrite;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCatalogId() != null)
            sb.append("CatalogId: ").append(getCatalogId()).append(",");
        if (getDatabaseName() != null)
            sb.append("DatabaseName: ").append(getDatabaseName()).append(",");
        if (getTableName() != null)
            sb.append("TableName: ").append(getTableName()).append(",");
        if (getS3Options() != null)
            sb.append("S3Options: ").append(getS3Options()).append(",");
        if (getDatabaseOptions() != null)
            sb.append("DatabaseOptions: ").append(getDatabaseOptions()).append(",");
        if (getOverwrite() != null)
            sb.append("Overwrite: ").append(getOverwrite());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DataCatalogOutput == false)
            return false;
        DataCatalogOutput other = (DataCatalogOutput) obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null)
            return false;
        if (other.getCatalogId() != null && other.getCatalogId().equals(this.getCatalogId()) == false)
            return false;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null)
            return false;
        if (other.getDatabaseName() != null && other.getDatabaseName().equals(this.getDatabaseName()) == false)
            return false;
        if (other.getTableName() == null ^ this.getTableName() == null)
            return false;
        if (other.getTableName() != null && other.getTableName().equals(this.getTableName()) == false)
            return false;
        if (other.getS3Options() == null ^ this.getS3Options() == null)
            return false;
        if (other.getS3Options() != null && other.getS3Options().equals(this.getS3Options()) == false)
            return false;
        if (other.getDatabaseOptions() == null ^ this.getDatabaseOptions() == null)
            return false;
        if (other.getDatabaseOptions() != null && other.getDatabaseOptions().equals(this.getDatabaseOptions()) == false)
            return false;
        if (other.getOverwrite() == null ^ this.getOverwrite() == null)
            return false;
        if (other.getOverwrite() != null && other.getOverwrite().equals(this.getOverwrite()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCatalogId() == null) ? 0 : getCatalogId().hashCode());
        hashCode = prime * hashCode + ((getDatabaseName() == null) ? 0 : getDatabaseName().hashCode());
        hashCode = prime * hashCode + ((getTableName() == null) ? 0 : getTableName().hashCode());
        hashCode = prime * hashCode + ((getS3Options() == null) ? 0 : getS3Options().hashCode());
        hashCode = prime * hashCode + ((getDatabaseOptions() == null) ? 0 : getDatabaseOptions().hashCode());
        hashCode = prime * hashCode + ((getOverwrite() == null) ? 0 : getOverwrite().hashCode());
        return hashCode;
    }

    @Override
    public DataCatalogOutput clone() {
        try {
            return (DataCatalogOutput) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.gluedatabrew.model.transform.DataCatalogOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
