/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/ListRulesets" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListRulesetsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those
     * rulesets that are associated with the specified resource.
     * </p>
     */
    private String targetArn;
    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To
     * get the next set of pages, pass in the NextToken value from the response object of the previous page call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those
     * rulesets that are associated with the specified resource.
     * </p>
     * 
     * @param targetArn
     *        The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only
     *        those rulesets that are associated with the specified resource.
     */

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those
     * rulesets that are associated with the specified resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only
     *         those rulesets that are associated with the specified resource.
     */

    public String getTargetArn() {
        return this.targetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only those
     * rulesets that are associated with the specified resource.
     * </p>
     * 
     * @param targetArn
     *        The Amazon Resource Name (ARN) of a resource (dataset). Using this parameter indicates to return only
     *        those rulesets that are associated with the specified resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRulesetsRequest withTargetArn(String targetArn) {
        setTargetArn(targetArn);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in this request.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     * 
     * @return The maximum number of results to return in this request.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRulesetsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To
     * get the next set of pages, pass in the NextToken value from the response object of the previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by DataBrew that specifies where to continue pagination if a previous request was
     *        truncated. To get the next set of pages, pass in the NextToken value from the response object of the
     *        previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To
     * get the next set of pages, pass in the NextToken value from the response object of the previous page call.
     * </p>
     * 
     * @return A token generated by DataBrew that specifies where to continue pagination if a previous request was
     *         truncated. To get the next set of pages, pass in the NextToken value from the response object of the
     *         previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To
     * get the next set of pages, pass in the NextToken value from the response object of the previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by DataBrew that specifies where to continue pagination if a previous request was
     *        truncated. To get the next set of pages, pass in the NextToken value from the response object of the
     *        previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRulesetsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTargetArn() != null)
            sb.append("TargetArn: ").append(getTargetArn()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListRulesetsRequest == false)
            return false;
        ListRulesetsRequest other = (ListRulesetsRequest) obj;
        if (other.getTargetArn() == null ^ this.getTargetArn() == null)
            return false;
        if (other.getTargetArn() != null && other.getTargetArn().equals(this.getTargetArn()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTargetArn() == null) ? 0 : getTargetArn().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListRulesetsRequest clone() {
        return (ListRulesetsRequest) super.clone();
    }

}
