/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrassv2;

import javax.annotation.Generated;

import com.amazonaws.services.greengrassv2.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGreengrassV2}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGreengrassV2 implements AWSGreengrassV2 {

    protected AbstractAWSGreengrassV2() {
    }

    @Override
    public AssociateServiceRoleToAccountResult associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchAssociateClientDeviceWithCoreDeviceResult batchAssociateClientDeviceWithCoreDevice(BatchAssociateClientDeviceWithCoreDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDisassociateClientDeviceFromCoreDeviceResult batchDisassociateClientDeviceFromCoreDevice(
            BatchDisassociateClientDeviceFromCoreDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelDeploymentResult cancelDeployment(CancelDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateComponentVersionResult createComponentVersion(CreateComponentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeploymentResult createDeployment(CreateDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteComponentResult deleteComponent(DeleteComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCoreDeviceResult deleteCoreDevice(DeleteCoreDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeploymentResult deleteDeployment(DeleteDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeComponentResult describeComponent(DescribeComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateServiceRoleFromAccountResult disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetComponentResult getComponent(GetComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetComponentVersionArtifactResult getComponentVersionArtifact(GetComponentVersionArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectivityInfoResult getConnectivityInfo(GetConnectivityInfoRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreDeviceResult getCoreDevice(GetCoreDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeploymentResult getDeployment(GetDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceRoleForAccountResult getServiceRoleForAccount(GetServiceRoleForAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClientDevicesAssociatedWithCoreDeviceResult listClientDevicesAssociatedWithCoreDevice(ListClientDevicesAssociatedWithCoreDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentVersionsResult listComponentVersions(ListComponentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentsResult listComponents(ListComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoreDevicesResult listCoreDevices(ListCoreDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeploymentsResult listDeployments(ListDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEffectiveDeploymentsResult listEffectiveDeployments(ListEffectiveDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInstalledComponentsResult listInstalledComponents(ListInstalledComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResolveComponentCandidatesResult resolveComponentCandidates(ResolveComponentCandidatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectivityInfoResult updateConnectivityInfo(UpdateConnectivityInfoRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
