/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.ContactData;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ContactDataMarshaller {
    private static final MarshallingInfo<String> CONTACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contactId").build();
    private static final MarshallingInfo<String> CONTACTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contactStatus").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorMessage").build();
    private static final MarshallingInfo<String> GROUNDSTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groundStation").build();
    private static final MarshallingInfo<StructuredPojo> MAXIMUMELEVATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximumElevation").build();
    private static final MarshallingInfo<String> MISSIONPROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("missionProfileArn").build();
    private static final MarshallingInfo<Date> POSTPASSENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postPassEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> PREPASSSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prePassStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SATELLITEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("satelliteArn").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final ContactDataMarshaller instance = new ContactDataMarshaller();

    public static ContactDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContactData contactData, ProtocolMarshaller protocolMarshaller) {
        if (contactData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)contactData.getContactId(), CONTACTID_BINDING);
            protocolMarshaller.marshall((Object)contactData.getContactStatus(), CONTACTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)contactData.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)contactData.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)contactData.getGroundStation(), GROUNDSTATION_BINDING);
            protocolMarshaller.marshall((Object)contactData.getMaximumElevation(), MAXIMUMELEVATION_BINDING);
            protocolMarshaller.marshall((Object)contactData.getMissionProfileArn(), MISSIONPROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)contactData.getPostPassEndTime(), POSTPASSENDTIME_BINDING);
            protocolMarshaller.marshall((Object)contactData.getPrePassStartTime(), PREPASSSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)contactData.getSatelliteArn(), SATELLITEARN_BINDING);
            protocolMarshaller.marshall((Object)contactData.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(contactData.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

