/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.groundstation;

import javax.annotation.Generated;

import com.amazonaws.services.groundstation.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGroundStation}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGroundStation implements AWSGroundStation {

    protected AbstractAWSGroundStation() {
    }

    @Override
    public CancelContactResult cancelContact(CancelContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfigResult createConfig(CreateConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataflowEndpointGroupResult createDataflowEndpointGroup(CreateDataflowEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEphemerisResult createEphemeris(CreateEphemerisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMissionProfileResult createMissionProfile(CreateMissionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfigResult deleteConfig(DeleteConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataflowEndpointGroupResult deleteDataflowEndpointGroup(DeleteDataflowEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEphemerisResult deleteEphemeris(DeleteEphemerisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMissionProfileResult deleteMissionProfile(DeleteMissionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeContactResult describeContact(DescribeContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEphemerisResult describeEphemeris(DescribeEphemerisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfigResult getConfig(GetConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataflowEndpointGroupResult getDataflowEndpointGroup(GetDataflowEndpointGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMinuteUsageResult getMinuteUsage(GetMinuteUsageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMissionProfileResult getMissionProfile(GetMissionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSatelliteResult getSatellite(GetSatelliteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfigsResult listConfigs(ListConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListContactsResult listContacts(ListContactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataflowEndpointGroupsResult listDataflowEndpointGroups(ListDataflowEndpointGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEphemeridesResult listEphemerides(ListEphemeridesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroundStationsResult listGroundStations(ListGroundStationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMissionProfilesResult listMissionProfiles(ListMissionProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSatellitesResult listSatellites(ListSatellitesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ReserveContactResult reserveContact(ReserveContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfigResult updateConfig(UpdateConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEphemerisResult updateEphemeris(UpdateEphemerisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMissionProfileResult updateMissionProfile(UpdateMissionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
