/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanSettings" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMalwareScanSettingsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Represents the criteria to be used in the filter for scanning resources.
     * </p>
     */
    private ScanResourceCriteria scanResourceCriteria;
    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     */
    private String ebsSnapshotPreservation;

    /**
     * <p>
     * Represents the criteria to be used in the filter for scanning resources.
     * </p>
     * 
     * @param scanResourceCriteria
     *        Represents the criteria to be used in the filter for scanning resources.
     */

    public void setScanResourceCriteria(ScanResourceCriteria scanResourceCriteria) {
        this.scanResourceCriteria = scanResourceCriteria;
    }

    /**
     * <p>
     * Represents the criteria to be used in the filter for scanning resources.
     * </p>
     * 
     * @return Represents the criteria to be used in the filter for scanning resources.
     */

    public ScanResourceCriteria getScanResourceCriteria() {
        return this.scanResourceCriteria;
    }

    /**
     * <p>
     * Represents the criteria to be used in the filter for scanning resources.
     * </p>
     * 
     * @param scanResourceCriteria
     *        Represents the criteria to be used in the filter for scanning resources.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareScanSettingsResult withScanResourceCriteria(ScanResourceCriteria scanResourceCriteria) {
        setScanResourceCriteria(scanResourceCriteria);
        return this;
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     * 
     * @param ebsSnapshotPreservation
     *        An enum value representing possible snapshot preservation settings.
     * @see EbsSnapshotPreservation
     */

    public void setEbsSnapshotPreservation(String ebsSnapshotPreservation) {
        this.ebsSnapshotPreservation = ebsSnapshotPreservation;
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     * 
     * @return An enum value representing possible snapshot preservation settings.
     * @see EbsSnapshotPreservation
     */

    public String getEbsSnapshotPreservation() {
        return this.ebsSnapshotPreservation;
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     * 
     * @param ebsSnapshotPreservation
     *        An enum value representing possible snapshot preservation settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EbsSnapshotPreservation
     */

    public GetMalwareScanSettingsResult withEbsSnapshotPreservation(String ebsSnapshotPreservation) {
        setEbsSnapshotPreservation(ebsSnapshotPreservation);
        return this;
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     * 
     * @param ebsSnapshotPreservation
     *        An enum value representing possible snapshot preservation settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EbsSnapshotPreservation
     */

    public GetMalwareScanSettingsResult withEbsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation) {
        this.ebsSnapshotPreservation = ebsSnapshotPreservation.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScanResourceCriteria() != null)
            sb.append("ScanResourceCriteria: ").append(getScanResourceCriteria()).append(",");
        if (getEbsSnapshotPreservation() != null)
            sb.append("EbsSnapshotPreservation: ").append(getEbsSnapshotPreservation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMalwareScanSettingsResult == false)
            return false;
        GetMalwareScanSettingsResult other = (GetMalwareScanSettingsResult) obj;
        if (other.getScanResourceCriteria() == null ^ this.getScanResourceCriteria() == null)
            return false;
        if (other.getScanResourceCriteria() != null && other.getScanResourceCriteria().equals(this.getScanResourceCriteria()) == false)
            return false;
        if (other.getEbsSnapshotPreservation() == null ^ this.getEbsSnapshotPreservation() == null)
            return false;
        if (other.getEbsSnapshotPreservation() != null && other.getEbsSnapshotPreservation().equals(this.getEbsSnapshotPreservation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScanResourceCriteria() == null) ? 0 : getScanResourceCriteria().hashCode());
        hashCode = prime * hashCode + ((getEbsSnapshotPreservation() == null) ? 0 : getEbsSnapshotPreservation().hashCode());
        return hashCode;
    }

    @Override
    public GetMalwareScanSettingsResult clone() {
        try {
            return (GetMalwareScanSettingsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
