/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.guardduty.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateMalwareProtectionPlanRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateMalwareProtectionPlanRequestMarshaller {

    private static final MarshallingInfo<String> MALWAREPROTECTIONPLANID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("malwareProtectionPlanId").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("role").build();
    private static final MarshallingInfo<StructuredPojo> ACTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<StructuredPojo> PROTECTEDRESOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protectedResource").build();

    private static final UpdateMalwareProtectionPlanRequestMarshaller instance = new UpdateMalwareProtectionPlanRequestMarshaller();

    public static UpdateMalwareProtectionPlanRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateMalwareProtectionPlanRequest updateMalwareProtectionPlanRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateMalwareProtectionPlanRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateMalwareProtectionPlanRequest.getMalwareProtectionPlanId(), MALWAREPROTECTIONPLANID_BINDING);
            protocolMarshaller.marshall(updateMalwareProtectionPlanRequest.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall(updateMalwareProtectionPlanRequest.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall(updateMalwareProtectionPlanRequest.getProtectedResource(), PROTECTEDRESOURCE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
