/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMalwareProtectionPlan"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateMalwareProtectionPlanRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     */
    private String role;
    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     */
    private CreateProtectedResource protectedResource;
    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     */
    private MalwareProtectionPlanActions actions;
    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @param clientToken
     *        The idempotency token for the create request.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @return The idempotency token for the create request.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @param clientToken
     *        The idempotency token for the create request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @param role
     *        IAM role with permissions required to scan and add tags to the associated protected resource.
     */

    public void setRole(String role) {
        this.role = role;
    }

    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @return IAM role with permissions required to scan and add tags to the associated protected resource.
     */

    public String getRole() {
        return this.role;
    }

    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @param role
     *        IAM role with permissions required to scan and add tags to the associated protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest withRole(String role) {
        setRole(role);
        return this;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @param protectedResource
     *        Information about the protected resource that is associated with the created Malware Protection plan.
     *        Presently, <code>S3Bucket</code> is the only supported protected resource.
     */

    public void setProtectedResource(CreateProtectedResource protectedResource) {
        this.protectedResource = protectedResource;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @return Information about the protected resource that is associated with the created Malware Protection plan.
     *         Presently, <code>S3Bucket</code> is the only supported protected resource.
     */

    public CreateProtectedResource getProtectedResource() {
        return this.protectedResource;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @param protectedResource
     *        Information about the protected resource that is associated with the created Malware Protection plan.
     *        Presently, <code>S3Bucket</code> is the only supported protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest withProtectedResource(CreateProtectedResource protectedResource) {
        setProtectedResource(protectedResource);
        return this;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @param actions
     *        Information about whether the tags will be added to the S3 object after scanning.
     */

    public void setActions(MalwareProtectionPlanActions actions) {
        this.actions = actions;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @return Information about whether the tags will be added to the S3 object after scanning.
     */

    public MalwareProtectionPlanActions getActions() {
        return this.actions;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @param actions
     *        Information about whether the tags will be added to the S3 object after scanning.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest withActions(MalwareProtectionPlanActions actions) {
        setActions(actions);
        return this;
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * 
     * @return Tags added to the Malware Protection plan resource.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * 
     * @param tags
     *        Tags added to the Malware Protection plan resource.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * 
     * @param tags
     *        Tags added to the Malware Protection plan resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateMalwareProtectionPlanRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMalwareProtectionPlanRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getRole() != null)
            sb.append("Role: ").append(getRole()).append(",");
        if (getProtectedResource() != null)
            sb.append("ProtectedResource: ").append(getProtectedResource()).append(",");
        if (getActions() != null)
            sb.append("Actions: ").append(getActions()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateMalwareProtectionPlanRequest == false)
            return false;
        CreateMalwareProtectionPlanRequest other = (CreateMalwareProtectionPlanRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getRole() == null ^ this.getRole() == null)
            return false;
        if (other.getRole() != null && other.getRole().equals(this.getRole()) == false)
            return false;
        if (other.getProtectedResource() == null ^ this.getProtectedResource() == null)
            return false;
        if (other.getProtectedResource() != null && other.getProtectedResource().equals(this.getProtectedResource()) == false)
            return false;
        if (other.getActions() == null ^ this.getActions() == null)
            return false;
        if (other.getActions() != null && other.getActions().equals(this.getActions()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getRole() == null) ? 0 : getRole().hashCode());
        hashCode = prime * hashCode + ((getProtectedResource() == null) ? 0 : getProtectedResource().hashCode());
        hashCode = prime * hashCode + ((getActions() == null) ? 0 : getActions().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateMalwareProtectionPlanRequest clone() {
        return (CreateMalwareProtectionPlanRequest) super.clone();
    }

}
