/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateOpenIDConnectProviderRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String url;
    private ListWithAutoConstructFlag<String> clientIDList;
    private ListWithAutoConstructFlag<String> thumbprintList;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CreateOpenIDConnectProviderRequest withUrl(String url) {
        this.url = url;
        return this;
    }

    public List<String> getClientIDList() {
        if (this.clientIDList == null) {
            this.clientIDList = new ListWithAutoConstructFlag();
            this.clientIDList.setAutoConstruct(true);
        }
        return this.clientIDList;
    }

    public void setClientIDList(Collection<String> clientIDList) {
        if (clientIDList == null) {
            this.clientIDList = null;
            return;
        }
        ListWithAutoConstructFlag clientIDListCopy = new ListWithAutoConstructFlag(clientIDList.size());
        clientIDListCopy.addAll(clientIDList);
        this.clientIDList = clientIDListCopy;
    }

    public CreateOpenIDConnectProviderRequest withClientIDList(String ... clientIDList) {
        if (this.getClientIDList() == null) {
            this.setClientIDList(new ArrayList<String>(clientIDList.length));
        }
        for (String value : clientIDList) {
            this.getClientIDList().add(value);
        }
        return this;
    }

    public CreateOpenIDConnectProviderRequest withClientIDList(Collection<String> clientIDList) {
        if (clientIDList == null) {
            this.clientIDList = null;
        } else {
            ListWithAutoConstructFlag clientIDListCopy = new ListWithAutoConstructFlag(clientIDList.size());
            clientIDListCopy.addAll(clientIDList);
            this.clientIDList = clientIDListCopy;
        }
        return this;
    }

    public List<String> getThumbprintList() {
        if (this.thumbprintList == null) {
            this.thumbprintList = new ListWithAutoConstructFlag();
            this.thumbprintList.setAutoConstruct(true);
        }
        return this.thumbprintList;
    }

    public void setThumbprintList(Collection<String> thumbprintList) {
        if (thumbprintList == null) {
            this.thumbprintList = null;
            return;
        }
        ListWithAutoConstructFlag thumbprintListCopy = new ListWithAutoConstructFlag(thumbprintList.size());
        thumbprintListCopy.addAll(thumbprintList);
        this.thumbprintList = thumbprintListCopy;
    }

    public CreateOpenIDConnectProviderRequest withThumbprintList(String ... thumbprintList) {
        if (this.getThumbprintList() == null) {
            this.setThumbprintList(new ArrayList<String>(thumbprintList.length));
        }
        for (String value : thumbprintList) {
            this.getThumbprintList().add(value);
        }
        return this;
    }

    public CreateOpenIDConnectProviderRequest withThumbprintList(Collection<String> thumbprintList) {
        if (thumbprintList == null) {
            this.thumbprintList = null;
        } else {
            ListWithAutoConstructFlag thumbprintListCopy = new ListWithAutoConstructFlag(thumbprintList.size());
            thumbprintListCopy.addAll(thumbprintList);
            this.thumbprintList = thumbprintListCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUrl() != null) {
            sb.append("Url: " + this.getUrl() + ",");
        }
        if (this.getClientIDList() != null) {
            sb.append("ClientIDList: " + this.getClientIDList() + ",");
        }
        if (this.getThumbprintList() != null) {
            sb.append("ThumbprintList: " + this.getThumbprintList());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        hashCode = 31 * hashCode + (this.getClientIDList() == null ? 0 : this.getClientIDList().hashCode());
        hashCode = 31 * hashCode + (this.getThumbprintList() == null ? 0 : this.getThumbprintList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpenIDConnectProviderRequest)) {
            return false;
        }
        CreateOpenIDConnectProviderRequest other = (CreateOpenIDConnectProviderRequest)obj;
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        if (other.getUrl() != null && !other.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other.getClientIDList() == null ^ this.getClientIDList() == null) {
            return false;
        }
        if (other.getClientIDList() != null && !other.getClientIDList().equals(this.getClientIDList())) {
            return false;
        }
        if (other.getThumbprintList() == null ^ this.getThumbprintList() == null) {
            return false;
        }
        return other.getThumbprintList() == null || other.getThumbprintList().equals(this.getThumbprintList());
    }

    public CreateOpenIDConnectProviderRequest clone() {
        return (CreateOpenIDConnectProviderRequest)super.clone();
    }
}

