/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.services.identitymanagement.model.TagInstanceProfileRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TagInstanceProfileRequestMarshaller
implements Marshaller<Request<TagInstanceProfileRequest>, TagInstanceProfileRequest> {
    public Request<TagInstanceProfileRequest> marshall(TagInstanceProfileRequest tagInstanceProfileRequest) {
        if (tagInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)tagInstanceProfileRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "TagInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagInstanceProfileRequest.getInstanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString((String)tagInstanceProfileRequest.getInstanceProfileName()));
        }
        if (!tagInstanceProfileRequest.getTags().isEmpty() || !((SdkInternalList)tagInstanceProfileRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)tagInstanceProfileRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

