/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.identitymanagement.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ServiceSpecificCredentialMetadata StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ServiceSpecificCredentialMetadataStaxUnmarshaller implements Unmarshaller<ServiceSpecificCredentialMetadata, StaxUnmarshallerContext> {

    public ServiceSpecificCredentialMetadata unmarshall(StaxUnmarshallerContext context) throws Exception {
        ServiceSpecificCredentialMetadata serviceSpecificCredentialMetadata = new ServiceSpecificCredentialMetadata();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return serviceSpecificCredentialMetadata;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("UserName", targetDepth)) {
                    serviceSpecificCredentialMetadata.setUserName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    serviceSpecificCredentialMetadata.setStatus(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ServiceUserName", targetDepth)) {
                    serviceSpecificCredentialMetadata.setServiceUserName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CreateDate", targetDepth)) {
                    serviceSpecificCredentialMetadata.setCreateDate(DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }

                if (context.testExpression("ServiceSpecificCredentialId", targetDepth)) {
                    serviceSpecificCredentialMetadata.setServiceSpecificCredentialId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ServiceName", targetDepth)) {
                    serviceSpecificCredentialMetadata.setServiceName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return serviceSpecificCredentialMetadata;
                }
            }
        }
    }

    private static ServiceSpecificCredentialMetadataStaxUnmarshaller instance;

    public static ServiceSpecificCredentialMetadataStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ServiceSpecificCredentialMetadataStaxUnmarshaller();
        return instance;
    }
}
