/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.identitystore.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/identitystore-2020-06-15/ListGroupMembershipsForMember"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListGroupMembershipsForMemberRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     */
    private String identityStoreId;
    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     */
    private MemberId memberId;
    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @param identityStoreId
     *        The globally unique identifier for the identity store.
     */

    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @return The globally unique identifier for the identity store.
     */

    public String getIdentityStoreId() {
        return this.identityStoreId;
    }

    /**
     * <p>
     * The globally unique identifier for the identity store.
     * </p>
     * 
     * @param identityStoreId
     *        The globally unique identifier for the identity store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsForMemberRequest withIdentityStoreId(String identityStoreId) {
        setIdentityStoreId(identityStoreId);
        return this;
    }

    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     * 
     * @param memberId
     *        An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
     *        specific identifier for a user indicates that the user is a member of the group.
     */

    public void setMemberId(MemberId memberId) {
        this.memberId = memberId;
    }

    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     * 
     * @return An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
     *         specific identifier for a user indicates that the user is a member of the group.
     */

    public MemberId getMemberId() {
        return this.memberId;
    }

    /**
     * <p>
     * An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific
     * identifier for a user indicates that the user is a member of the group.
     * </p>
     * 
     * @param memberId
     *        An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the
     *        specific identifier for a user indicates that the user is a member of the group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsForMemberRequest withMemberId(MemberId memberId) {
        setMemberId(memberId);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to be returned per request. This parameter is used in the
     *        <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *        page. The length limit is 50 characters.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @return The maximum number of results to be returned per request. This parameter is used in the
     *         <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *         page. The length limit is 50 characters.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code>
     * and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50
     * characters.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to be returned per request. This parameter is used in the
     *        <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one
     *        page. The length limit is 50 characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsForMemberRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     *        <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *        It is returned in the API response if the total results are more than the size of one page. This token is
     *        also returned when it is used in the API request to search for the next page.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @return The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     *         <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *         It is returned in the API response if the total results are more than the size of one page. This token is
     *         also returned when it is used in the API request to search for the next page.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     * <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is
     * returned in the API response if the total results are more than the size of one page. This token is also returned
     * when it is used in the API request to search for the next page.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and
     *        <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service.
     *        It is returned in the API response if the total results are more than the size of one page. This token is
     *        also returned when it is used in the API request to search for the next page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListGroupMembershipsForMemberRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIdentityStoreId() != null)
            sb.append("IdentityStoreId: ").append(getIdentityStoreId()).append(",");
        if (getMemberId() != null)
            sb.append("MemberId: ").append(getMemberId()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListGroupMembershipsForMemberRequest == false)
            return false;
        ListGroupMembershipsForMemberRequest other = (ListGroupMembershipsForMemberRequest) obj;
        if (other.getIdentityStoreId() == null ^ this.getIdentityStoreId() == null)
            return false;
        if (other.getIdentityStoreId() != null && other.getIdentityStoreId().equals(this.getIdentityStoreId()) == false)
            return false;
        if (other.getMemberId() == null ^ this.getMemberId() == null)
            return false;
        if (other.getMemberId() != null && other.getMemberId().equals(this.getMemberId()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIdentityStoreId() == null) ? 0 : getIdentityStoreId().hashCode());
        hashCode = prime * hashCode + ((getMemberId() == null) ? 0 : getMemberId().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListGroupMembershipsForMemberRequest clone() {
        return (ListGroupMembershipsForMemberRequest) super.clone();
    }

}
