/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.DistributionConfiguration;
import com.amazonaws.services.imagebuilder.model.ImageRecipe;
import com.amazonaws.services.imagebuilder.model.ImageState;
import com.amazonaws.services.imagebuilder.model.ImageTestsConfiguration;
import com.amazonaws.services.imagebuilder.model.InfrastructureConfiguration;
import com.amazonaws.services.imagebuilder.model.OutputResources;
import com.amazonaws.services.imagebuilder.model.Platform;
import com.amazonaws.services.imagebuilder.model.transform.ImageMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Image
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String version;
    private String platform;
    private ImageState state;
    private ImageRecipe imageRecipe;
    private String sourcePipelineName;
    private String sourcePipelineArn;
    private InfrastructureConfiguration infrastructureConfiguration;
    private DistributionConfiguration distributionConfiguration;
    private ImageTestsConfiguration imageTestsConfiguration;
    private String dateCreated;
    private OutputResources outputResources;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Image withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Image withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Image withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public Image withPlatform(Platform platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setState(ImageState state) {
        this.state = state;
    }

    public ImageState getState() {
        return this.state;
    }

    public Image withState(ImageState state) {
        this.setState(state);
        return this;
    }

    public void setImageRecipe(ImageRecipe imageRecipe) {
        this.imageRecipe = imageRecipe;
    }

    public ImageRecipe getImageRecipe() {
        return this.imageRecipe;
    }

    public Image withImageRecipe(ImageRecipe imageRecipe) {
        this.setImageRecipe(imageRecipe);
        return this;
    }

    public void setSourcePipelineName(String sourcePipelineName) {
        this.sourcePipelineName = sourcePipelineName;
    }

    public String getSourcePipelineName() {
        return this.sourcePipelineName;
    }

    public Image withSourcePipelineName(String sourcePipelineName) {
        this.setSourcePipelineName(sourcePipelineName);
        return this;
    }

    public void setSourcePipelineArn(String sourcePipelineArn) {
        this.sourcePipelineArn = sourcePipelineArn;
    }

    public String getSourcePipelineArn() {
        return this.sourcePipelineArn;
    }

    public Image withSourcePipelineArn(String sourcePipelineArn) {
        this.setSourcePipelineArn(sourcePipelineArn);
        return this;
    }

    public void setInfrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
        this.infrastructureConfiguration = infrastructureConfiguration;
    }

    public InfrastructureConfiguration getInfrastructureConfiguration() {
        return this.infrastructureConfiguration;
    }

    public Image withInfrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
        this.setInfrastructureConfiguration(infrastructureConfiguration);
        return this;
    }

    public void setDistributionConfiguration(DistributionConfiguration distributionConfiguration) {
        this.distributionConfiguration = distributionConfiguration;
    }

    public DistributionConfiguration getDistributionConfiguration() {
        return this.distributionConfiguration;
    }

    public Image withDistributionConfiguration(DistributionConfiguration distributionConfiguration) {
        this.setDistributionConfiguration(distributionConfiguration);
        return this;
    }

    public void setImageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
        this.imageTestsConfiguration = imageTestsConfiguration;
    }

    public ImageTestsConfiguration getImageTestsConfiguration() {
        return this.imageTestsConfiguration;
    }

    public Image withImageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
        this.setImageTestsConfiguration(imageTestsConfiguration);
        return this;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public Image withDateCreated(String dateCreated) {
        this.setDateCreated(dateCreated);
        return this;
    }

    public void setOutputResources(OutputResources outputResources) {
        this.outputResources = outputResources;
    }

    public OutputResources getOutputResources() {
        return this.outputResources;
    }

    public Image withOutputResources(OutputResources outputResources) {
        this.setOutputResources(outputResources);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Image withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Image addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Image clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getImageRecipe() != null) {
            sb.append("ImageRecipe: ").append(this.getImageRecipe()).append(",");
        }
        if (this.getSourcePipelineName() != null) {
            sb.append("SourcePipelineName: ").append(this.getSourcePipelineName()).append(",");
        }
        if (this.getSourcePipelineArn() != null) {
            sb.append("SourcePipelineArn: ").append(this.getSourcePipelineArn()).append(",");
        }
        if (this.getInfrastructureConfiguration() != null) {
            sb.append("InfrastructureConfiguration: ").append(this.getInfrastructureConfiguration()).append(",");
        }
        if (this.getDistributionConfiguration() != null) {
            sb.append("DistributionConfiguration: ").append(this.getDistributionConfiguration()).append(",");
        }
        if (this.getImageTestsConfiguration() != null) {
            sb.append("ImageTestsConfiguration: ").append(this.getImageTestsConfiguration()).append(",");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: ").append(this.getDateCreated()).append(",");
        }
        if (this.getOutputResources() != null) {
            sb.append("OutputResources: ").append(this.getOutputResources()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getImageRecipe() == null ^ this.getImageRecipe() == null) {
            return false;
        }
        if (other.getImageRecipe() != null && !other.getImageRecipe().equals(this.getImageRecipe())) {
            return false;
        }
        if (other.getSourcePipelineName() == null ^ this.getSourcePipelineName() == null) {
            return false;
        }
        if (other.getSourcePipelineName() != null && !other.getSourcePipelineName().equals(this.getSourcePipelineName())) {
            return false;
        }
        if (other.getSourcePipelineArn() == null ^ this.getSourcePipelineArn() == null) {
            return false;
        }
        if (other.getSourcePipelineArn() != null && !other.getSourcePipelineArn().equals(this.getSourcePipelineArn())) {
            return false;
        }
        if (other.getInfrastructureConfiguration() == null ^ this.getInfrastructureConfiguration() == null) {
            return false;
        }
        if (other.getInfrastructureConfiguration() != null && !other.getInfrastructureConfiguration().equals(this.getInfrastructureConfiguration())) {
            return false;
        }
        if (other.getDistributionConfiguration() == null ^ this.getDistributionConfiguration() == null) {
            return false;
        }
        if (other.getDistributionConfiguration() != null && !other.getDistributionConfiguration().equals(this.getDistributionConfiguration())) {
            return false;
        }
        if (other.getImageTestsConfiguration() == null ^ this.getImageTestsConfiguration() == null) {
            return false;
        }
        if (other.getImageTestsConfiguration() != null && !other.getImageTestsConfiguration().equals(this.getImageTestsConfiguration())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        if (other.getDateCreated() != null && !other.getDateCreated().equals(this.getDateCreated())) {
            return false;
        }
        if (other.getOutputResources() == null ^ this.getOutputResources() == null) {
            return false;
        }
        if (other.getOutputResources() != null && !other.getOutputResources().equals(this.getOutputResources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getImageRecipe() == null ? 0 : this.getImageRecipe().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePipelineName() == null ? 0 : this.getSourcePipelineName().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePipelineArn() == null ? 0 : this.getSourcePipelineArn().hashCode());
        hashCode = 31 * hashCode + (this.getInfrastructureConfiguration() == null ? 0 : this.getInfrastructureConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDistributionConfiguration() == null ? 0 : this.getDistributionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getImageTestsConfiguration() == null ? 0 : this.getImageTestsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        hashCode = 31 * hashCode + (this.getOutputResources() == null ? 0 : this.getOutputResources().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Image clone() {
        try {
            return (Image)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

