/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.imagebuilder.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ListWorkflowStepExecutionsResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListWorkflowStepExecutionsResultJsonUnmarshaller implements Unmarshaller<ListWorkflowStepExecutionsResult, JsonUnmarshallerContext> {

    public ListWorkflowStepExecutionsResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        ListWorkflowStepExecutionsResult listWorkflowStepExecutionsResult = new ListWorkflowStepExecutionsResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return listWorkflowStepExecutionsResult;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("requestId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setRequestId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("steps", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setSteps(new ListUnmarshaller<WorkflowStepMetadata>(WorkflowStepMetadataJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("workflowBuildVersionArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setWorkflowBuildVersionArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("workflowExecutionId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setWorkflowExecutionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("imageBuildVersionArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setImageBuildVersionArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("message", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("nextToken", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    listWorkflowStepExecutionsResult.setNextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return listWorkflowStepExecutionsResult;
    }

    private static ListWorkflowStepExecutionsResultJsonUnmarshaller instance;

    public static ListWorkflowStepExecutionsResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ListWorkflowStepExecutionsResultJsonUnmarshaller();
        return instance;
    }
}
