/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.imagebuilder.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Specifies how the lifecycle policy should apply actions to selected resources.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/LifecyclePolicyDetailActionIncludeResources"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class LifecyclePolicyDetailActionIncludeResources implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed AMIs.
     * </p>
     */
    private Boolean amis;
    /**
     * <p>
     * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * </p>
     */
    private Boolean snapshots;
    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed containers.
     * </p>
     */
    private Boolean containers;

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed AMIs.
     * </p>
     * 
     * @param amis
     *        Specifies whether the lifecycle action should apply to distributed AMIs.
     */

    public void setAmis(Boolean amis) {
        this.amis = amis;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed AMIs.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to distributed AMIs.
     */

    public Boolean getAmis() {
        return this.amis;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed AMIs.
     * </p>
     * 
     * @param amis
     *        Specifies whether the lifecycle action should apply to distributed AMIs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LifecyclePolicyDetailActionIncludeResources withAmis(Boolean amis) {
        setAmis(amis);
        return this;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed AMIs.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to distributed AMIs.
     */

    public Boolean isAmis() {
        return this.amis;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * </p>
     * 
     * @param snapshots
     *        Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     */

    public void setSnapshots(Boolean snapshots) {
        this.snapshots = snapshots;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     */

    public Boolean getSnapshots() {
        return this.snapshots;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * </p>
     * 
     * @param snapshots
     *        Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LifecyclePolicyDetailActionIncludeResources withSnapshots(Boolean snapshots) {
        setSnapshots(snapshots);
        return this;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     */

    public Boolean isSnapshots() {
        return this.snapshots;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed containers.
     * </p>
     * 
     * @param containers
     *        Specifies whether the lifecycle action should apply to distributed containers.
     */

    public void setContainers(Boolean containers) {
        this.containers = containers;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed containers.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to distributed containers.
     */

    public Boolean getContainers() {
        return this.containers;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed containers.
     * </p>
     * 
     * @param containers
     *        Specifies whether the lifecycle action should apply to distributed containers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LifecyclePolicyDetailActionIncludeResources withContainers(Boolean containers) {
        setContainers(containers);
        return this;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed containers.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to distributed containers.
     */

    public Boolean isContainers() {
        return this.containers;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAmis() != null)
            sb.append("Amis: ").append(getAmis()).append(",");
        if (getSnapshots() != null)
            sb.append("Snapshots: ").append(getSnapshots()).append(",");
        if (getContainers() != null)
            sb.append("Containers: ").append(getContainers());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof LifecyclePolicyDetailActionIncludeResources == false)
            return false;
        LifecyclePolicyDetailActionIncludeResources other = (LifecyclePolicyDetailActionIncludeResources) obj;
        if (other.getAmis() == null ^ this.getAmis() == null)
            return false;
        if (other.getAmis() != null && other.getAmis().equals(this.getAmis()) == false)
            return false;
        if (other.getSnapshots() == null ^ this.getSnapshots() == null)
            return false;
        if (other.getSnapshots() != null && other.getSnapshots().equals(this.getSnapshots()) == false)
            return false;
        if (other.getContainers() == null ^ this.getContainers() == null)
            return false;
        if (other.getContainers() != null && other.getContainers().equals(this.getContainers()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAmis() == null) ? 0 : getAmis().hashCode());
        hashCode = prime * hashCode + ((getSnapshots() == null) ? 0 : getSnapshots().hashCode());
        hashCode = prime * hashCode + ((getContainers() == null) ? 0 : getContainers().hashCode());
        return hashCode;
    }

    @Override
    public LifecyclePolicyDetailActionIncludeResources clone() {
        try {
            return (LifecyclePolicyDetailActionIncludeResources) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.imagebuilder.model.transform.LifecyclePolicyDetailActionIncludeResourcesMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
