/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.importexport.model.Job;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListJobsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Job> jobs;
    private Boolean isTruncated;

    public List<Job> getJobs() {
        if (this.jobs == null) {
            this.jobs = new SdkInternalList();
        }
        return this.jobs;
    }

    public void setJobs(Collection<Job> jobs) {
        if (jobs == null) {
            this.jobs = null;
            return;
        }
        this.jobs = new SdkInternalList(jobs);
    }

    public ListJobsResult withJobs(Job ... jobs) {
        if (this.jobs == null) {
            this.setJobs((Collection<Job>)new SdkInternalList(jobs.length));
        }
        for (Job ele : jobs) {
            this.jobs.add((Object)ele);
        }
        return this;
    }

    public ListJobsResult withJobs(Collection<Job> jobs) {
        this.setJobs(jobs);
        return this;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public ListJobsResult withIsTruncated(Boolean isTruncated) {
        this.setIsTruncated(isTruncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobs() != null) {
            sb.append("Jobs: " + this.getJobs() + ",");
        }
        if (this.getIsTruncated() != null) {
            sb.append("IsTruncated: " + this.getIsTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResult)) {
            return false;
        }
        ListJobsResult other = (ListJobsResult)obj;
        if (other.getJobs() == null ^ this.getJobs() == null) {
            return false;
        }
        if (other.getJobs() != null && !other.getJobs().equals(this.getJobs())) {
            return false;
        }
        if (other.getIsTruncated() == null ^ this.getIsTruncated() == null) {
            return false;
        }
        return other.getIsTruncated() == null || other.getIsTruncated().equals(this.getIsTruncated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobs() == null ? 0 : this.getJobs().hashCode());
        hashCode = 31 * hashCode + (this.getIsTruncated() == null ? 0 : this.getIsTruncated().hashCode());
        return hashCode;
    }

    public ListJobsResult clone() {
        try {
            return (ListJobsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

