/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.inspector;

import com.amazonaws.services.inspector.model.*;

/**
 * Interface for accessing Amazon Inspector asynchronously. Each asynchronous
 * method will return a Java Future object representing the asynchronous
 * operation; overloads which accept an {@code AsyncHandler} can be used to
 * receive notification when an asynchronous operation completes.
 * <p>
 * <fullname>Amazon Inspector</fullname>
 * <p>
 * Amazon Inspector enables you to analyze the behavior of the applications you
 * run in AWS and to identify potential security issues. For more information,
 * see <a href=
 * "https://docs.aws.amazon.com/inspector/latest/userguide//inspector_introduction.html"
 * > Amazon Inspector User Guide</a>.
 * </p>
 */
public interface AmazonInspectorAsync extends AmazonInspector {

    /**
     * <p>
     * Assigns attributes (key and value pair) to the findings specified by the
     * findings' ARNs.
     * </p>
     * 
     * @param addAttributesToFindingsRequest
     * @return A Java Future containing the result of the
     *         AddAttributesToFindings operation returned by the service.
     */
    java.util.concurrent.Future<AddAttributesToFindingsResult> addAttributesToFindingsAsync(
            AddAttributesToFindingsRequest addAttributesToFindingsRequest);

    /**
     * <p>
     * Assigns attributes (key and value pair) to the findings specified by the
     * findings' ARNs.
     * </p>
     * 
     * @param addAttributesToFindingsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         AddAttributesToFindings operation returned by the service.
     */
    java.util.concurrent.Future<AddAttributesToFindingsResult> addAttributesToFindingsAsync(
            AddAttributesToFindingsRequest addAttributesToFindingsRequest,
            com.amazonaws.handlers.AsyncHandler<AddAttributesToFindingsRequest, AddAttributesToFindingsResult> asyncHandler);

    /**
     * <p>
     * Attaches the rules package specified by the rules package ARN to the
     * assessment specified by the assessment ARN.
     * </p>
     * 
     * @param attachAssessmentAndRulesPackageRequest
     * @return A Java Future containing the result of the
     *         AttachAssessmentAndRulesPackage operation returned by the
     *         service.
     */
    java.util.concurrent.Future<AttachAssessmentAndRulesPackageResult> attachAssessmentAndRulesPackageAsync(
            AttachAssessmentAndRulesPackageRequest attachAssessmentAndRulesPackageRequest);

    /**
     * <p>
     * Attaches the rules package specified by the rules package ARN to the
     * assessment specified by the assessment ARN.
     * </p>
     * 
     * @param attachAssessmentAndRulesPackageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         AttachAssessmentAndRulesPackage operation returned by the
     *         service.
     */
    java.util.concurrent.Future<AttachAssessmentAndRulesPackageResult> attachAssessmentAndRulesPackageAsync(
            AttachAssessmentAndRulesPackageRequest attachAssessmentAndRulesPackageRequest,
            com.amazonaws.handlers.AsyncHandler<AttachAssessmentAndRulesPackageRequest, AttachAssessmentAndRulesPackageResult> asyncHandler);

    /**
     * <p>
     * Creates a new application using the resource group ARN generated by
     * <a>CreateResourceGroup</a>. You can create up to 50 applications per AWS
     * account. You can run up to 500 concurrent agents per AWS account. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html"
     * > Inspector Applications.</a>
     * </p>
     * 
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<CreateApplicationResult> createApplicationAsync(
            CreateApplicationRequest createApplicationRequest);

    /**
     * <p>
     * Creates a new application using the resource group ARN generated by
     * <a>CreateResourceGroup</a>. You can create up to 50 applications per AWS
     * account. You can run up to 500 concurrent agents per AWS account. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html"
     * > Inspector Applications.</a>
     * </p>
     * 
     * @param createApplicationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<CreateApplicationResult> createApplicationAsync(
            CreateApplicationRequest createApplicationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler);

    /**
     * <p>
     * Creates an assessment for the application specified by the application
     * ARN. You can create up to 500 assessments per AWS account.
     * </p>
     * 
     * @param createAssessmentRequest
     * @return A Java Future containing the result of the CreateAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<CreateAssessmentResult> createAssessmentAsync(
            CreateAssessmentRequest createAssessmentRequest);

    /**
     * <p>
     * Creates an assessment for the application specified by the application
     * ARN. You can create up to 500 assessments per AWS account.
     * </p>
     * 
     * @param createAssessmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<CreateAssessmentResult> createAssessmentAsync(
            CreateAssessmentRequest createAssessmentRequest,
            com.amazonaws.handlers.AsyncHandler<CreateAssessmentRequest, CreateAssessmentResult> asyncHandler);

    /**
     * <p>
     * Creates a resource group using the specified set of tags (key and value
     * pairs) that are used to select the EC2 instances to be included in an
     * Inspector application. The created resource group is then used to create
     * an Inspector application.
     * </p>
     * 
     * @param createResourceGroupRequest
     * @return A Java Future containing the result of the CreateResourceGroup
     *         operation returned by the service.
     */
    java.util.concurrent.Future<CreateResourceGroupResult> createResourceGroupAsync(
            CreateResourceGroupRequest createResourceGroupRequest);

    /**
     * <p>
     * Creates a resource group using the specified set of tags (key and value
     * pairs) that are used to select the EC2 instances to be included in an
     * Inspector application. The created resource group is then used to create
     * an Inspector application.
     * </p>
     * 
     * @param createResourceGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateResourceGroup
     *         operation returned by the service.
     */
    java.util.concurrent.Future<CreateResourceGroupResult> createResourceGroupAsync(
            CreateResourceGroupRequest createResourceGroupRequest,
            com.amazonaws.handlers.AsyncHandler<CreateResourceGroupRequest, CreateResourceGroupResult> asyncHandler);

    /**
     * <p>
     * Deletes the application specified by the application ARN.
     * </p>
     * 
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DeleteApplicationResult> deleteApplicationAsync(
            DeleteApplicationRequest deleteApplicationRequest);

    /**
     * <p>
     * Deletes the application specified by the application ARN.
     * </p>
     * 
     * @param deleteApplicationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DeleteApplicationResult> deleteApplicationAsync(
            DeleteApplicationRequest deleteApplicationRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler);

    /**
     * <p>
     * Deletes the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param deleteAssessmentRequest
     * @return A Java Future containing the result of the DeleteAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DeleteAssessmentResult> deleteAssessmentAsync(
            DeleteAssessmentRequest deleteAssessmentRequest);

    /**
     * <p>
     * Deletes the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param deleteAssessmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DeleteAssessmentResult> deleteAssessmentAsync(
            DeleteAssessmentRequest deleteAssessmentRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteAssessmentRequest, DeleteAssessmentResult> asyncHandler);

    /**
     * <p>
     * Deletes the assessment run specified by the run ARN.
     * </p>
     * 
     * @param deleteRunRequest
     * @return A Java Future containing the result of the DeleteRun operation
     *         returned by the service.
     */
    java.util.concurrent.Future<DeleteRunResult> deleteRunAsync(
            DeleteRunRequest deleteRunRequest);

    /**
     * <p>
     * Deletes the assessment run specified by the run ARN.
     * </p>
     * 
     * @param deleteRunRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteRun operation
     *         returned by the service.
     */
    java.util.concurrent.Future<DeleteRunResult> deleteRunAsync(
            DeleteRunRequest deleteRunRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteRunRequest, DeleteRunResult> asyncHandler);

    /**
     * <p>
     * Describes the application specified by the application ARN.
     * </p>
     * 
     * @param describeApplicationRequest
     * @return A Java Future containing the result of the DescribeApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeApplicationResult> describeApplicationAsync(
            DescribeApplicationRequest describeApplicationRequest);

    /**
     * <p>
     * Describes the application specified by the application ARN.
     * </p>
     * 
     * @param describeApplicationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeApplicationResult> describeApplicationAsync(
            DescribeApplicationRequest describeApplicationRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeApplicationRequest, DescribeApplicationResult> asyncHandler);

    /**
     * <p>
     * Describes the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param describeAssessmentRequest
     * @return A Java Future containing the result of the DescribeAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeAssessmentResult> describeAssessmentAsync(
            DescribeAssessmentRequest describeAssessmentRequest);

    /**
     * <p>
     * Describes the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param describeAssessmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeAssessmentResult> describeAssessmentAsync(
            DescribeAssessmentRequest describeAssessmentRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAssessmentRequest, DescribeAssessmentResult> asyncHandler);

    /**
     * <p>
     * Describes the IAM role that enables Inspector to access your AWS account.
     * </p>
     * 
     * @param describeCrossAccountAccessRoleRequest
     * @return A Java Future containing the result of the
     *         DescribeCrossAccountAccessRole operation returned by the service.
     */
    java.util.concurrent.Future<DescribeCrossAccountAccessRoleResult> describeCrossAccountAccessRoleAsync(
            DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest);

    /**
     * <p>
     * Describes the IAM role that enables Inspector to access your AWS account.
     * </p>
     * 
     * @param describeCrossAccountAccessRoleRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         DescribeCrossAccountAccessRole operation returned by the service.
     */
    java.util.concurrent.Future<DescribeCrossAccountAccessRoleResult> describeCrossAccountAccessRoleAsync(
            DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCrossAccountAccessRoleRequest, DescribeCrossAccountAccessRoleResult> asyncHandler);

    /**
     * <p>
     * Describes the finding specified by the finding ARN.
     * </p>
     * 
     * @param describeFindingRequest
     * @return A Java Future containing the result of the DescribeFinding
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeFindingResult> describeFindingAsync(
            DescribeFindingRequest describeFindingRequest);

    /**
     * <p>
     * Describes the finding specified by the finding ARN.
     * </p>
     * 
     * @param describeFindingRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFinding
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeFindingResult> describeFindingAsync(
            DescribeFindingRequest describeFindingRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFindingRequest, DescribeFindingResult> asyncHandler);

    /**
     * <p>
     * Describes the resource group specified by the resource group ARN.
     * </p>
     * 
     * @param describeResourceGroupRequest
     * @return A Java Future containing the result of the DescribeResourceGroup
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeResourceGroupResult> describeResourceGroupAsync(
            DescribeResourceGroupRequest describeResourceGroupRequest);

    /**
     * <p>
     * Describes the resource group specified by the resource group ARN.
     * </p>
     * 
     * @param describeResourceGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeResourceGroup
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeResourceGroupResult> describeResourceGroupAsync(
            DescribeResourceGroupRequest describeResourceGroupRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeResourceGroupRequest, DescribeResourceGroupResult> asyncHandler);

    /**
     * <p>
     * Describes the rules package specified by the rules package ARN.
     * </p>
     * 
     * @param describeRulesPackageRequest
     * @return A Java Future containing the result of the DescribeRulesPackage
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeRulesPackageResult> describeRulesPackageAsync(
            DescribeRulesPackageRequest describeRulesPackageRequest);

    /**
     * <p>
     * Describes the rules package specified by the rules package ARN.
     * </p>
     * 
     * @param describeRulesPackageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeRulesPackage
     *         operation returned by the service.
     */
    java.util.concurrent.Future<DescribeRulesPackageResult> describeRulesPackageAsync(
            DescribeRulesPackageRequest describeRulesPackageRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeRulesPackageRequest, DescribeRulesPackageResult> asyncHandler);

    /**
     * <p>
     * Describes the assessment run specified by the run ARN.
     * </p>
     * 
     * @param describeRunRequest
     * @return A Java Future containing the result of the DescribeRun operation
     *         returned by the service.
     */
    java.util.concurrent.Future<DescribeRunResult> describeRunAsync(
            DescribeRunRequest describeRunRequest);

    /**
     * <p>
     * Describes the assessment run specified by the run ARN.
     * </p>
     * 
     * @param describeRunRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeRun operation
     *         returned by the service.
     */
    java.util.concurrent.Future<DescribeRunResult> describeRunAsync(
            DescribeRunRequest describeRunRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeRunRequest, DescribeRunResult> asyncHandler);

    /**
     * <p>
     * Detaches the rules package specified by the rules package ARN from the
     * assessment specified by the assessment ARN.
     * </p>
     * 
     * @param detachAssessmentAndRulesPackageRequest
     * @return A Java Future containing the result of the
     *         DetachAssessmentAndRulesPackage operation returned by the
     *         service.
     */
    java.util.concurrent.Future<DetachAssessmentAndRulesPackageResult> detachAssessmentAndRulesPackageAsync(
            DetachAssessmentAndRulesPackageRequest detachAssessmentAndRulesPackageRequest);

    /**
     * <p>
     * Detaches the rules package specified by the rules package ARN from the
     * assessment specified by the assessment ARN.
     * </p>
     * 
     * @param detachAssessmentAndRulesPackageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         DetachAssessmentAndRulesPackage operation returned by the
     *         service.
     */
    java.util.concurrent.Future<DetachAssessmentAndRulesPackageResult> detachAssessmentAndRulesPackageAsync(
            DetachAssessmentAndRulesPackageRequest detachAssessmentAndRulesPackageRequest,
            com.amazonaws.handlers.AsyncHandler<DetachAssessmentAndRulesPackageRequest, DetachAssessmentAndRulesPackageResult> asyncHandler);

    /**
     * <p>
     * Returns the metadata about the telemetry (application behavioral data)
     * for the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param getAssessmentTelemetryRequest
     * @return A Java Future containing the result of the GetAssessmentTelemetry
     *         operation returned by the service.
     */
    java.util.concurrent.Future<GetAssessmentTelemetryResult> getAssessmentTelemetryAsync(
            GetAssessmentTelemetryRequest getAssessmentTelemetryRequest);

    /**
     * <p>
     * Returns the metadata about the telemetry (application behavioral data)
     * for the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param getAssessmentTelemetryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the GetAssessmentTelemetry
     *         operation returned by the service.
     */
    java.util.concurrent.Future<GetAssessmentTelemetryResult> getAssessmentTelemetryAsync(
            GetAssessmentTelemetryRequest getAssessmentTelemetryRequest,
            com.amazonaws.handlers.AsyncHandler<GetAssessmentTelemetryRequest, GetAssessmentTelemetryResult> asyncHandler);

    /**
     * <p>
     * Lists the ARNs of the applications within this AWS account. For more
     * information about applications, see <a href=
     * "https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html"
     * >Inspector Applications</a>.
     * </p>
     * 
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListApplicationsResult> listApplicationsAsync(
            ListApplicationsRequest listApplicationsRequest);

    /**
     * <p>
     * Lists the ARNs of the applications within this AWS account. For more
     * information about applications, see <a href=
     * "https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html"
     * >Inspector Applications</a>.
     * </p>
     * 
     * @param listApplicationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListApplications
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListApplicationsResult> listApplicationsAsync(
            ListApplicationsRequest listApplicationsRequest,
            com.amazonaws.handlers.AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler);

    /**
     * <p>
     * Lists the agents of the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param listAssessmentAgentsRequest
     * @return A Java Future containing the result of the ListAssessmentAgents
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListAssessmentAgentsResult> listAssessmentAgentsAsync(
            ListAssessmentAgentsRequest listAssessmentAgentsRequest);

    /**
     * <p>
     * Lists the agents of the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param listAssessmentAgentsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListAssessmentAgents
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListAssessmentAgentsResult> listAssessmentAgentsAsync(
            ListAssessmentAgentsRequest listAssessmentAgentsRequest,
            com.amazonaws.handlers.AsyncHandler<ListAssessmentAgentsRequest, ListAssessmentAgentsResult> asyncHandler);

    /**
     * <p>
     * Lists the assessments corresponding to applications specified by the
     * applications' ARNs.
     * </p>
     * 
     * @param listAssessmentsRequest
     * @return A Java Future containing the result of the ListAssessments
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListAssessmentsResult> listAssessmentsAsync(
            ListAssessmentsRequest listAssessmentsRequest);

    /**
     * <p>
     * Lists the assessments corresponding to applications specified by the
     * applications' ARNs.
     * </p>
     * 
     * @param listAssessmentsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListAssessments
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListAssessmentsResult> listAssessmentsAsync(
            ListAssessmentsRequest listAssessmentsRequest,
            com.amazonaws.handlers.AsyncHandler<ListAssessmentsRequest, ListAssessmentsResult> asyncHandler);

    /**
     * <p>
     * Lists the assessments attached to the rules package specified by the
     * rules package ARN.
     * </p>
     * 
     * @param listAttachedAssessmentsRequest
     * @return A Java Future containing the result of the
     *         ListAttachedAssessments operation returned by the service.
     */
    java.util.concurrent.Future<ListAttachedAssessmentsResult> listAttachedAssessmentsAsync(
            ListAttachedAssessmentsRequest listAttachedAssessmentsRequest);

    /**
     * <p>
     * Lists the assessments attached to the rules package specified by the
     * rules package ARN.
     * </p>
     * 
     * @param listAttachedAssessmentsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         ListAttachedAssessments operation returned by the service.
     */
    java.util.concurrent.Future<ListAttachedAssessmentsResult> listAttachedAssessmentsAsync(
            ListAttachedAssessmentsRequest listAttachedAssessmentsRequest,
            com.amazonaws.handlers.AsyncHandler<ListAttachedAssessmentsRequest, ListAttachedAssessmentsResult> asyncHandler);

    /**
     * <p>
     * Lists the rules packages attached to the assessment specified by the
     * assessment ARN.
     * </p>
     * 
     * @param listAttachedRulesPackagesRequest
     * @return A Java Future containing the result of the
     *         ListAttachedRulesPackages operation returned by the service.
     */
    java.util.concurrent.Future<ListAttachedRulesPackagesResult> listAttachedRulesPackagesAsync(
            ListAttachedRulesPackagesRequest listAttachedRulesPackagesRequest);

    /**
     * <p>
     * Lists the rules packages attached to the assessment specified by the
     * assessment ARN.
     * </p>
     * 
     * @param listAttachedRulesPackagesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         ListAttachedRulesPackages operation returned by the service.
     */
    java.util.concurrent.Future<ListAttachedRulesPackagesResult> listAttachedRulesPackagesAsync(
            ListAttachedRulesPackagesRequest listAttachedRulesPackagesRequest,
            com.amazonaws.handlers.AsyncHandler<ListAttachedRulesPackagesRequest, ListAttachedRulesPackagesResult> asyncHandler);

    /**
     * <p>
     * Lists findings generated by the assessment run specified by the run ARNs.
     * </p>
     * 
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation
     *         returned by the service.
     */
    java.util.concurrent.Future<ListFindingsResult> listFindingsAsync(
            ListFindingsRequest listFindingsRequest);

    /**
     * <p>
     * Lists findings generated by the assessment run specified by the run ARNs.
     * </p>
     * 
     * @param listFindingsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListFindings operation
     *         returned by the service.
     */
    java.util.concurrent.Future<ListFindingsResult> listFindingsAsync(
            ListFindingsRequest listFindingsRequest,
            com.amazonaws.handlers.AsyncHandler<ListFindingsRequest, ListFindingsResult> asyncHandler);

    /**
     * <p>
     * Lists all available Inspector rules packages.
     * </p>
     * 
     * @param listRulesPackagesRequest
     * @return A Java Future containing the result of the ListRulesPackages
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListRulesPackagesResult> listRulesPackagesAsync(
            ListRulesPackagesRequest listRulesPackagesRequest);

    /**
     * <p>
     * Lists all available Inspector rules packages.
     * </p>
     * 
     * @param listRulesPackagesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListRulesPackages
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListRulesPackagesResult> listRulesPackagesAsync(
            ListRulesPackagesRequest listRulesPackagesRequest,
            com.amazonaws.handlers.AsyncHandler<ListRulesPackagesRequest, ListRulesPackagesResult> asyncHandler);

    /**
     * <p>
     * Lists the assessment runs associated with the assessments specified by
     * the assessment ARNs.
     * </p>
     * 
     * @param listRunsRequest
     * @return A Java Future containing the result of the ListRuns operation
     *         returned by the service.
     */
    java.util.concurrent.Future<ListRunsResult> listRunsAsync(
            ListRunsRequest listRunsRequest);

    /**
     * <p>
     * Lists the assessment runs associated with the assessments specified by
     * the assessment ARNs.
     * </p>
     * 
     * @param listRunsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListRuns operation
     *         returned by the service.
     */
    java.util.concurrent.Future<ListRunsResult> listRunsAsync(
            ListRunsRequest listRunsRequest,
            com.amazonaws.handlers.AsyncHandler<ListRunsRequest, ListRunsResult> asyncHandler);

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     * 
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(
            ListTagsForResourceRequest listTagsForResourceRequest);

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     * 
     * @param listTagsForResourceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ListTagsForResource
     *         operation returned by the service.
     */
    java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(
            ListTagsForResourceRequest listTagsForResourceRequest,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler);

    /**
     * <p>
     * Translates a textual identifier into a user-readable text in a specified
     * locale.
     * </p>
     * 
     * @param localizeTextRequest
     * @return A Java Future containing the result of the LocalizeText operation
     *         returned by the service.
     */
    java.util.concurrent.Future<LocalizeTextResult> localizeTextAsync(
            LocalizeTextRequest localizeTextRequest);

    /**
     * <p>
     * Translates a textual identifier into a user-readable text in a specified
     * locale.
     * </p>
     * 
     * @param localizeTextRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the LocalizeText operation
     *         returned by the service.
     */
    java.util.concurrent.Future<LocalizeTextResult> localizeTextAsync(
            LocalizeTextRequest localizeTextRequest,
            com.amazonaws.handlers.AsyncHandler<LocalizeTextRequest, LocalizeTextResult> asyncHandler);

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are included in
     * the application created with the specified resource group.
     * </p>
     * 
     * @param previewAgentsForResourceGroupRequest
     * @return A Java Future containing the result of the
     *         PreviewAgentsForResourceGroup operation returned by the service.
     */
    java.util.concurrent.Future<PreviewAgentsForResourceGroupResult> previewAgentsForResourceGroupAsync(
            PreviewAgentsForResourceGroupRequest previewAgentsForResourceGroupRequest);

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are included in
     * the application created with the specified resource group.
     * </p>
     * 
     * @param previewAgentsForResourceGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         PreviewAgentsForResourceGroup operation returned by the service.
     */
    java.util.concurrent.Future<PreviewAgentsForResourceGroupResult> previewAgentsForResourceGroupAsync(
            PreviewAgentsForResourceGroupRequest previewAgentsForResourceGroupRequest,
            com.amazonaws.handlers.AsyncHandler<PreviewAgentsForResourceGroupRequest, PreviewAgentsForResourceGroupResult> asyncHandler);

    /**
     * <p>
     * Register the role that Inspector uses to list your EC2 instances during
     * the assessment.
     * </p>
     * 
     * @param registerCrossAccountAccessRoleRequest
     * @return A Java Future containing the result of the
     *         RegisterCrossAccountAccessRole operation returned by the service.
     */
    java.util.concurrent.Future<RegisterCrossAccountAccessRoleResult> registerCrossAccountAccessRoleAsync(
            RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest);

    /**
     * <p>
     * Register the role that Inspector uses to list your EC2 instances during
     * the assessment.
     * </p>
     * 
     * @param registerCrossAccountAccessRoleRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         RegisterCrossAccountAccessRole operation returned by the service.
     */
    java.util.concurrent.Future<RegisterCrossAccountAccessRoleResult> registerCrossAccountAccessRoleAsync(
            RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest,
            com.amazonaws.handlers.AsyncHandler<RegisterCrossAccountAccessRoleRequest, RegisterCrossAccountAccessRoleResult> asyncHandler);

    /**
     * <p>
     * Removes the entire attribute (key and value pair) from the findings
     * specified by the finding ARNs where an attribute with the specified key
     * exists.
     * </p>
     * 
     * @param removeAttributesFromFindingsRequest
     * @return A Java Future containing the result of the
     *         RemoveAttributesFromFindings operation returned by the service.
     */
    java.util.concurrent.Future<RemoveAttributesFromFindingsResult> removeAttributesFromFindingsAsync(
            RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest);

    /**
     * <p>
     * Removes the entire attribute (key and value pair) from the findings
     * specified by the finding ARNs where an attribute with the specified key
     * exists.
     * </p>
     * 
     * @param removeAttributesFromFindingsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         RemoveAttributesFromFindings operation returned by the service.
     */
    java.util.concurrent.Future<RemoveAttributesFromFindingsResult> removeAttributesFromFindingsAsync(
            RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest,
            com.amazonaws.handlers.AsyncHandler<RemoveAttributesFromFindingsRequest, RemoveAttributesFromFindingsResult> asyncHandler);

    /**
     * <p>
     * Starts the analysis of the application’s behavior against selected rule
     * packages for the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param runAssessmentRequest
     * @return A Java Future containing the result of the RunAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<RunAssessmentResult> runAssessmentAsync(
            RunAssessmentRequest runAssessmentRequest);

    /**
     * <p>
     * Starts the analysis of the application’s behavior against selected rule
     * packages for the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param runAssessmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the RunAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<RunAssessmentResult> runAssessmentAsync(
            RunAssessmentRequest runAssessmentRequest,
            com.amazonaws.handlers.AsyncHandler<RunAssessmentRequest, RunAssessmentResult> asyncHandler);

    /**
     * <p>
     * Sets tags (key and value pairs) to the assessment specified by the
     * assessment ARN.
     * </p>
     * 
     * @param setTagsForResourceRequest
     * @return A Java Future containing the result of the SetTagsForResource
     *         operation returned by the service.
     */
    java.util.concurrent.Future<SetTagsForResourceResult> setTagsForResourceAsync(
            SetTagsForResourceRequest setTagsForResourceRequest);

    /**
     * <p>
     * Sets tags (key and value pairs) to the assessment specified by the
     * assessment ARN.
     * </p>
     * 
     * @param setTagsForResourceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the SetTagsForResource
     *         operation returned by the service.
     */
    java.util.concurrent.Future<SetTagsForResourceResult> setTagsForResourceAsync(
            SetTagsForResourceRequest setTagsForResourceRequest,
            com.amazonaws.handlers.AsyncHandler<SetTagsForResourceRequest, SetTagsForResourceResult> asyncHandler);

    /**
     * <p>
     * Starts data collection for the assessment specified by the assessment
     * ARN. For this API to function properly, you must not exceed the limit of
     * running up to 500 concurrent agents per AWS account.
     * </p>
     * 
     * @param startDataCollectionRequest
     * @return A Java Future containing the result of the StartDataCollection
     *         operation returned by the service.
     */
    java.util.concurrent.Future<StartDataCollectionResult> startDataCollectionAsync(
            StartDataCollectionRequest startDataCollectionRequest);

    /**
     * <p>
     * Starts data collection for the assessment specified by the assessment
     * ARN. For this API to function properly, you must not exceed the limit of
     * running up to 500 concurrent agents per AWS account.
     * </p>
     * 
     * @param startDataCollectionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the StartDataCollection
     *         operation returned by the service.
     */
    java.util.concurrent.Future<StartDataCollectionResult> startDataCollectionAsync(
            StartDataCollectionRequest startDataCollectionRequest,
            com.amazonaws.handlers.AsyncHandler<StartDataCollectionRequest, StartDataCollectionResult> asyncHandler);

    /**
     * <p>
     * Stop data collection for the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param stopDataCollectionRequest
     * @return A Java Future containing the result of the StopDataCollection
     *         operation returned by the service.
     */
    java.util.concurrent.Future<StopDataCollectionResult> stopDataCollectionAsync(
            StopDataCollectionRequest stopDataCollectionRequest);

    /**
     * <p>
     * Stop data collection for the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param stopDataCollectionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the StopDataCollection
     *         operation returned by the service.
     */
    java.util.concurrent.Future<StopDataCollectionResult> stopDataCollectionAsync(
            StopDataCollectionRequest stopDataCollectionRequest,
            com.amazonaws.handlers.AsyncHandler<StopDataCollectionRequest, StopDataCollectionResult> asyncHandler);

    /**
     * <p>
     * Updates application specified by the application ARN.
     * </p>
     * 
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<UpdateApplicationResult> updateApplicationAsync(
            UpdateApplicationRequest updateApplicationRequest);

    /**
     * <p>
     * Updates application specified by the application ARN.
     * </p>
     * 
     * @param updateApplicationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the UpdateApplication
     *         operation returned by the service.
     */
    java.util.concurrent.Future<UpdateApplicationResult> updateApplicationAsync(
            UpdateApplicationRequest updateApplicationRequest,
            com.amazonaws.handlers.AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler);

    /**
     * <p>
     * Updates the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param updateAssessmentRequest
     * @return A Java Future containing the result of the UpdateAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<UpdateAssessmentResult> updateAssessmentAsync(
            UpdateAssessmentRequest updateAssessmentRequest);

    /**
     * <p>
     * Updates the assessment specified by the assessment ARN.
     * </p>
     * 
     * @param updateAssessmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the
     *        request. Users can provide an implementation of the callback
     *        methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the UpdateAssessment
     *         operation returned by the service.
     */
    java.util.concurrent.Future<UpdateAssessmentResult> updateAssessmentAsync(
            UpdateAssessmentRequest updateAssessmentRequest,
            com.amazonaws.handlers.AsyncHandler<UpdateAssessmentRequest, UpdateAssessmentResult> asyncHandler);

}
