/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Assessment;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class AssessmentJsonMarshaller {
    private static AssessmentJsonMarshaller instance;

    public void marshall(Assessment assessment, JSONWriter jsonWriter) {
        if (assessment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesForFindingsList;
            jsonWriter.object();
            if (assessment.getAssessmentArn() != null) {
                jsonWriter.key("assessmentArn").value((Object)assessment.getAssessmentArn());
            }
            if (assessment.getAssessmentName() != null) {
                jsonWriter.key("assessmentName").value((Object)assessment.getAssessmentName());
            }
            if (assessment.getApplicationArn() != null) {
                jsonWriter.key("applicationArn").value((Object)assessment.getApplicationArn());
            }
            if (assessment.getAssessmentState() != null) {
                jsonWriter.key("assessmentState").value((Object)assessment.getAssessmentState());
            }
            if (assessment.getFailureMessage() != null) {
                jsonWriter.key("failureMessage").value((Object)assessment.getFailureMessage());
            }
            if (assessment.getDataCollected() != null) {
                jsonWriter.key("dataCollected").value((Object)assessment.getDataCollected());
            }
            if (assessment.getStartTime() != null) {
                jsonWriter.key("startTime").value(assessment.getStartTime());
            }
            if (assessment.getEndTime() != null) {
                jsonWriter.key("endTime").value(assessment.getEndTime());
            }
            if (assessment.getDurationInSeconds() != null) {
                jsonWriter.key("durationInSeconds").value((Object)assessment.getDurationInSeconds());
            }
            if ((userAttributesForFindingsList = assessment.getUserAttributesForFindings()) != null) {
                jsonWriter.key("userAttributesForFindings");
                jsonWriter.array();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentJsonMarshaller();
        }
        return instance;
    }
}

