/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.inspector.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAssessmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationArn;
    private String assessmentName;
    private Integer durationInSeconds;
    private List<Attribute> userAttributesForFindings;

    public void setApplicationArn(String applicationArn) {
        this.applicationArn = applicationArn;
    }

    public String getApplicationArn() {
        return this.applicationArn;
    }

    public CreateAssessmentRequest withApplicationArn(String applicationArn) {
        this.setApplicationArn(applicationArn);
        return this;
    }

    public void setAssessmentName(String assessmentName) {
        this.assessmentName = assessmentName;
    }

    public String getAssessmentName() {
        return this.assessmentName;
    }

    public CreateAssessmentRequest withAssessmentName(String assessmentName) {
        this.setAssessmentName(assessmentName);
        return this;
    }

    public void setDurationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    public Integer getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public CreateAssessmentRequest withDurationInSeconds(Integer durationInSeconds) {
        this.setDurationInSeconds(durationInSeconds);
        return this;
    }

    public List<Attribute> getUserAttributesForFindings() {
        return this.userAttributesForFindings;
    }

    public void setUserAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
        if (userAttributesForFindings == null) {
            this.userAttributesForFindings = null;
            return;
        }
        this.userAttributesForFindings = new ArrayList<Attribute>(userAttributesForFindings);
    }

    public CreateAssessmentRequest withUserAttributesForFindings(Attribute ... userAttributesForFindings) {
        if (this.userAttributesForFindings == null) {
            this.setUserAttributesForFindings(new ArrayList<Attribute>(userAttributesForFindings.length));
        }
        for (Attribute ele : userAttributesForFindings) {
            this.userAttributesForFindings.add(ele);
        }
        return this;
    }

    public CreateAssessmentRequest withUserAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
        this.setUserAttributesForFindings(userAttributesForFindings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationArn() != null) {
            sb.append("ApplicationArn: " + this.getApplicationArn() + ",");
        }
        if (this.getAssessmentName() != null) {
            sb.append("AssessmentName: " + this.getAssessmentName() + ",");
        }
        if (this.getDurationInSeconds() != null) {
            sb.append("DurationInSeconds: " + this.getDurationInSeconds() + ",");
        }
        if (this.getUserAttributesForFindings() != null) {
            sb.append("UserAttributesForFindings: " + this.getUserAttributesForFindings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentRequest)) {
            return false;
        }
        CreateAssessmentRequest other = (CreateAssessmentRequest)obj;
        if (other.getApplicationArn() == null ^ this.getApplicationArn() == null) {
            return false;
        }
        if (other.getApplicationArn() != null && !other.getApplicationArn().equals(this.getApplicationArn())) {
            return false;
        }
        if (other.getAssessmentName() == null ^ this.getAssessmentName() == null) {
            return false;
        }
        if (other.getAssessmentName() != null && !other.getAssessmentName().equals(this.getAssessmentName())) {
            return false;
        }
        if (other.getDurationInSeconds() == null ^ this.getDurationInSeconds() == null) {
            return false;
        }
        if (other.getDurationInSeconds() != null && !other.getDurationInSeconds().equals(this.getDurationInSeconds())) {
            return false;
        }
        if (other.getUserAttributesForFindings() == null ^ this.getUserAttributesForFindings() == null) {
            return false;
        }
        return other.getUserAttributesForFindings() == null || other.getUserAttributesForFindings().equals(this.getUserAttributesForFindings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationArn() == null ? 0 : this.getApplicationArn().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentName() == null ? 0 : this.getAssessmentName().hashCode());
        hashCode = 31 * hashCode + (this.getDurationInSeconds() == null ? 0 : this.getDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributesForFindings() == null ? 0 : this.getUserAttributesForFindings().hashCode());
        return hashCode;
    }

    public CreateAssessmentRequest clone() {
        return (CreateAssessmentRequest)super.clone();
    }
}

