/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.Finding;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.LocalizedTextJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class FindingJsonMarshaller {
    private static FindingJsonMarshaller instance;

    public void marshall(Finding finding, JSONWriter jsonWriter) {
        if (finding == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesList;
            List<Attribute> attributesList;
            jsonWriter.object();
            if (finding.getFindingArn() != null) {
                jsonWriter.key("findingArn").value((Object)finding.getFindingArn());
            }
            if (finding.getRunArn() != null) {
                jsonWriter.key("runArn").value((Object)finding.getRunArn());
            }
            if (finding.getRulesPackageArn() != null) {
                jsonWriter.key("rulesPackageArn").value((Object)finding.getRulesPackageArn());
            }
            if (finding.getRuleName() != null) {
                jsonWriter.key("ruleName").value((Object)finding.getRuleName());
            }
            if (finding.getAgentId() != null) {
                jsonWriter.key("agentId").value((Object)finding.getAgentId());
            }
            if (finding.getAutoScalingGroup() != null) {
                jsonWriter.key("autoScalingGroup").value((Object)finding.getAutoScalingGroup());
            }
            if (finding.getSeverity() != null) {
                jsonWriter.key("severity").value((Object)finding.getSeverity());
            }
            if (finding.getFinding() != null) {
                jsonWriter.key("finding");
                LocalizedTextJsonMarshaller.getInstance().marshall(finding.getFinding(), jsonWriter);
            }
            if (finding.getDescription() != null) {
                jsonWriter.key("description");
                LocalizedTextJsonMarshaller.getInstance().marshall(finding.getDescription(), jsonWriter);
            }
            if (finding.getRecommendation() != null) {
                jsonWriter.key("recommendation");
                LocalizedTextJsonMarshaller.getInstance().marshall(finding.getRecommendation(), jsonWriter);
            }
            if ((attributesList = finding.getAttributes()) != null) {
                jsonWriter.key("attributes");
                jsonWriter.array();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((userAttributesList = finding.getUserAttributes()) != null) {
                jsonWriter.key("userAttributes");
                jsonWriter.array();
                for (Attribute userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingJsonMarshaller();
        }
        return instance;
    }
}

