/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.AssessmentsFilter;
import com.amazonaws.services.inspector.model.transform.DurationRangeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class AssessmentsFilterJsonMarshaller {
    private static AssessmentsFilterJsonMarshaller instance;

    public void marshall(AssessmentsFilter assessmentsFilter, SdkJsonGenerator jsonGenerator) {
        if (assessmentsFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> assessmentStatesList;
            jsonGenerator.writeStartObject();
            List<String> assessmentNamePatternsList = assessmentsFilter.getAssessmentNamePatterns();
            if (assessmentNamePatternsList != null) {
                jsonGenerator.writeFieldName("assessmentNamePatterns");
                jsonGenerator.writeStartArray();
                for (String assessmentNamePatternsListValue : assessmentNamePatternsList) {
                    if (assessmentNamePatternsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentNamePatternsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((assessmentStatesList = assessmentsFilter.getAssessmentStates()) != null) {
                jsonGenerator.writeFieldName("assessmentStates");
                jsonGenerator.writeStartArray();
                for (String assessmentStatesListValue : assessmentStatesList) {
                    if (assessmentStatesListValue == null) continue;
                    jsonGenerator.writeValue(assessmentStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (assessmentsFilter.getDataCollected() != null) {
                jsonGenerator.writeFieldName("dataCollected").writeValue(assessmentsFilter.getDataCollected().booleanValue());
            }
            if (assessmentsFilter.getStartTimeRange() != null) {
                jsonGenerator.writeFieldName("startTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentsFilter.getStartTimeRange(), jsonGenerator);
            }
            if (assessmentsFilter.getEndTimeRange() != null) {
                jsonGenerator.writeFieldName("endTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentsFilter.getEndTimeRange(), jsonGenerator);
            }
            if (assessmentsFilter.getDurationRange() != null) {
                jsonGenerator.writeFieldName("durationRange");
                DurationRangeJsonMarshaller.getInstance().marshall(assessmentsFilter.getDurationRange(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentsFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentsFilterJsonMarshaller();
        }
        return instance;
    }
}

