/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.CreateAssessmentRequest;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateAssessmentRequestMarshaller
implements Marshaller<Request<CreateAssessmentRequest>, CreateAssessmentRequest> {
    public Request<CreateAssessmentRequest> marshall(CreateAssessmentRequest createAssessmentRequest) {
        if (createAssessmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAssessmentRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateAssessment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> userAttributesForFindingsList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createAssessmentRequest.getApplicationArn() != null) {
                jsonGenerator.writeFieldName("applicationArn").writeValue(createAssessmentRequest.getApplicationArn());
            }
            if (createAssessmentRequest.getAssessmentName() != null) {
                jsonGenerator.writeFieldName("assessmentName").writeValue(createAssessmentRequest.getAssessmentName());
            }
            if (createAssessmentRequest.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue((long)createAssessmentRequest.getDurationInSeconds().intValue());
            }
            if ((userAttributesForFindingsList = createAssessmentRequest.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

