/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.Finding;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.LocalizedTextJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class FindingJsonMarshaller {
    private static FindingJsonMarshaller instance;

    public void marshall(Finding finding, SdkJsonGenerator jsonGenerator) {
        if (finding == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesList;
            List<Attribute> attributesList;
            jsonGenerator.writeStartObject();
            if (finding.getFindingArn() != null) {
                jsonGenerator.writeFieldName("findingArn").writeValue(finding.getFindingArn());
            }
            if (finding.getRunArn() != null) {
                jsonGenerator.writeFieldName("runArn").writeValue(finding.getRunArn());
            }
            if (finding.getRulesPackageArn() != null) {
                jsonGenerator.writeFieldName("rulesPackageArn").writeValue(finding.getRulesPackageArn());
            }
            if (finding.getRuleName() != null) {
                jsonGenerator.writeFieldName("ruleName").writeValue(finding.getRuleName());
            }
            if (finding.getAgentId() != null) {
                jsonGenerator.writeFieldName("agentId").writeValue(finding.getAgentId());
            }
            if (finding.getAutoScalingGroup() != null) {
                jsonGenerator.writeFieldName("autoScalingGroup").writeValue(finding.getAutoScalingGroup());
            }
            if (finding.getSeverity() != null) {
                jsonGenerator.writeFieldName("severity").writeValue(finding.getSeverity());
            }
            if (finding.getFinding() != null) {
                jsonGenerator.writeFieldName("finding");
                LocalizedTextJsonMarshaller.getInstance().marshall(finding.getFinding(), jsonGenerator);
            }
            if (finding.getDescription() != null) {
                jsonGenerator.writeFieldName("description");
                LocalizedTextJsonMarshaller.getInstance().marshall(finding.getDescription(), jsonGenerator);
            }
            if (finding.getRecommendation() != null) {
                jsonGenerator.writeFieldName("recommendation");
                LocalizedTextJsonMarshaller.getInstance().marshall(finding.getRecommendation(), jsonGenerator);
            }
            if ((attributesList = finding.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesList = finding.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("userAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingJsonMarshaller();
        }
        return instance;
    }
}

