/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.transform.FindingsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ListFindingsRequestMarshaller
implements Marshaller<Request<ListFindingsRequest>, ListFindingsRequest> {
    public Request<ListFindingsRequest> marshall(ListFindingsRequest listFindingsRequest) {
        if (listFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<String> runArnsList = listFindingsRequest.getRunArns();
            if (runArnsList != null) {
                jsonGenerator.writeFieldName("runArns");
                jsonGenerator.writeStartArray();
                for (String runArnsListValue : runArnsList) {
                    if (runArnsListValue == null) continue;
                    jsonGenerator.writeValue(runArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listFindingsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                FindingsFilterJsonMarshaller.getInstance().marshall(listFindingsRequest.getFilter(), jsonGenerator);
            }
            if (listFindingsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listFindingsRequest.getNextToken());
            }
            if (listFindingsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue((long)listFindingsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

