/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.RulesPackage;
import com.amazonaws.services.inspector.model.transform.LocalizedTextJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class RulesPackageJsonMarshaller {
    private static RulesPackageJsonMarshaller instance;

    public void marshall(RulesPackage rulesPackage, SdkJsonGenerator jsonGenerator) {
        if (rulesPackage == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (rulesPackage.getRulesPackageArn() != null) {
                jsonGenerator.writeFieldName("rulesPackageArn").writeValue(rulesPackage.getRulesPackageArn());
            }
            if (rulesPackage.getRulesPackageName() != null) {
                jsonGenerator.writeFieldName("rulesPackageName").writeValue(rulesPackage.getRulesPackageName());
            }
            if (rulesPackage.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(rulesPackage.getVersion());
            }
            if (rulesPackage.getProvider() != null) {
                jsonGenerator.writeFieldName("provider").writeValue(rulesPackage.getProvider());
            }
            if (rulesPackage.getDescription() != null) {
                jsonGenerator.writeFieldName("description");
                LocalizedTextJsonMarshaller.getInstance().marshall(rulesPackage.getDescription(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RulesPackageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RulesPackageJsonMarshaller();
        }
        return instance;
    }
}

