/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.RunAssessmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RunAssessmentRequestMarshaller
implements Marshaller<Request<RunAssessmentRequest>, RunAssessmentRequest> {
    public Request<RunAssessmentRequest> marshall(RunAssessmentRequest runAssessmentRequest) {
        if (runAssessmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runAssessmentRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.RunAssessment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (runAssessmentRequest.getAssessmentArn() != null) {
                jsonGenerator.writeFieldName("assessmentArn").writeValue(runAssessmentRequest.getAssessmentArn());
            }
            if (runAssessmentRequest.getRunName() != null) {
                jsonGenerator.writeFieldName("runName").writeValue(runAssessmentRequest.getRunName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

