/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Run;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class RunJsonMarshaller {
    private static RunJsonMarshaller instance;

    public void marshall(Run run, SdkJsonGenerator jsonGenerator) {
        if (run == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> rulesPackagesList;
            jsonGenerator.writeStartObject();
            if (run.getRunArn() != null) {
                jsonGenerator.writeFieldName("runArn").writeValue(run.getRunArn());
            }
            if (run.getRunName() != null) {
                jsonGenerator.writeFieldName("runName").writeValue(run.getRunName());
            }
            if (run.getAssessmentArn() != null) {
                jsonGenerator.writeFieldName("assessmentArn").writeValue(run.getAssessmentArn());
            }
            if (run.getRunState() != null) {
                jsonGenerator.writeFieldName("runState").writeValue(run.getRunState());
            }
            if ((rulesPackagesList = run.getRulesPackages()) != null) {
                jsonGenerator.writeFieldName("rulesPackages");
                jsonGenerator.writeStartArray();
                for (String rulesPackagesListValue : rulesPackagesList) {
                    if (rulesPackagesListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackagesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (run.getCreationTime() != null) {
                jsonGenerator.writeFieldName("creationTime").writeValue(run.getCreationTime());
            }
            if (run.getCompletionTime() != null) {
                jsonGenerator.writeFieldName("completionTime").writeValue(run.getCompletionTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RunJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RunJsonMarshaller();
        }
        return instance;
    }
}

