/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.UpdateAssessmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateAssessmentRequestMarshaller
implements Marshaller<Request<UpdateAssessmentRequest>, UpdateAssessmentRequest> {
    public Request<UpdateAssessmentRequest> marshall(UpdateAssessmentRequest updateAssessmentRequest) {
        if (updateAssessmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAssessmentRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.UpdateAssessment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateAssessmentRequest.getAssessmentArn() != null) {
                jsonGenerator.writeFieldName("assessmentArn").writeValue(updateAssessmentRequest.getAssessmentArn());
            }
            if (updateAssessmentRequest.getAssessmentName() != null) {
                jsonGenerator.writeFieldName("assessmentName").writeValue(updateAssessmentRequest.getAssessmentName());
            }
            if (updateAssessmentRequest.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue((long)updateAssessmentRequest.getDurationInSeconds().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

