/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Agent;
import com.amazonaws.services.inspector.model.Telemetry;
import com.amazonaws.services.inspector.model.transform.TelemetryJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class AgentJsonMarshaller {
    private static AgentJsonMarshaller instance;

    public void marshall(Agent agent, SdkJsonGenerator jsonGenerator) {
        if (agent == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Telemetry> telemetryList;
            jsonGenerator.writeStartObject();
            if (agent.getAgentId() != null) {
                jsonGenerator.writeFieldName("agentId").writeValue(agent.getAgentId());
            }
            if (agent.getAssessmentArn() != null) {
                jsonGenerator.writeFieldName("assessmentArn").writeValue(agent.getAssessmentArn());
            }
            if (agent.getAgentHealth() != null) {
                jsonGenerator.writeFieldName("agentHealth").writeValue(agent.getAgentHealth());
            }
            if (agent.getAgentHealthCode() != null) {
                jsonGenerator.writeFieldName("agentHealthCode").writeValue(agent.getAgentHealthCode());
            }
            if (agent.getAgentHealthDetails() != null) {
                jsonGenerator.writeFieldName("agentHealthDetails").writeValue(agent.getAgentHealthDetails());
            }
            if (agent.getAutoScalingGroup() != null) {
                jsonGenerator.writeFieldName("autoScalingGroup").writeValue(agent.getAutoScalingGroup());
            }
            if (agent.getAccountId() != null) {
                jsonGenerator.writeFieldName("accountId").writeValue(agent.getAccountId());
            }
            if ((telemetryList = agent.getTelemetry()) != null) {
                jsonGenerator.writeFieldName("telemetry");
                jsonGenerator.writeStartArray();
                for (Telemetry telemetryListValue : telemetryList) {
                    if (telemetryListValue == null) continue;
                    TelemetryJsonMarshaller.getInstance().marshall(telemetryListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AgentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AgentJsonMarshaller();
        }
        return instance;
    }
}

