/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.FindingsFilter;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class FindingsFilterJsonMarshaller {
    private static FindingsFilterJsonMarshaller instance;

    public void marshall(FindingsFilter findingsFilter, SdkJsonGenerator jsonGenerator) {
        if (findingsFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesList;
            List<Attribute> attributesList;
            List<String> severitiesList;
            List<String> ruleNamesList;
            jsonGenerator.writeStartObject();
            List<String> rulesPackageArnsList = findingsFilter.getRulesPackageArns();
            if (rulesPackageArnsList != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((ruleNamesList = findingsFilter.getRuleNames()) != null) {
                jsonGenerator.writeFieldName("ruleNames");
                jsonGenerator.writeStartArray();
                for (String ruleNamesListValue : ruleNamesList) {
                    if (ruleNamesListValue == null) continue;
                    jsonGenerator.writeValue(ruleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((severitiesList = findingsFilter.getSeverities()) != null) {
                jsonGenerator.writeFieldName("severities");
                jsonGenerator.writeStartArray();
                for (String severitiesListValue : severitiesList) {
                    if (severitiesListValue == null) continue;
                    jsonGenerator.writeValue(severitiesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((attributesList = findingsFilter.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesList = findingsFilter.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("userAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingsFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingsFilterJsonMarshaller();
        }
        return instance;
    }
}

