/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListApplicationsRequest;
import com.amazonaws.services.inspector.model.transform.ApplicationsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListApplicationsRequestMarshaller
implements Marshaller<Request<ListApplicationsRequest>, ListApplicationsRequest> {
    public Request<ListApplicationsRequest> marshall(ListApplicationsRequest listApplicationsRequest) {
        if (listApplicationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listApplicationsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListApplications");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listApplicationsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                ApplicationsFilterJsonMarshaller.getInstance().marshall(listApplicationsRequest.getFilter(), jsonGenerator);
            }
            if (listApplicationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listApplicationsRequest.getNextToken());
            }
            if (listApplicationsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue((long)listApplicationsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

